/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.dto.AddOrganismEngineRequestDto;
import org.genemania.engine.IMania;
import org.genemania.engine.Mania2;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.engine.cache.MemObjectCache;
import org.genemania.engine.cache.SynchronizedObjectCache;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.apps.AbstractPluginApp;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.IModelWriter;
import org.genemania.plugin.data.Namespace;
import org.genemania.plugin.parsers.IdFileParser;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.xml.sax.SAXException;

public class IdImporter
extends AbstractPluginApp {
    protected DataSet fData;
    @Option(name="--data", usage="optional, path to a GeneMANIA data set (e.g. gmdata-2010-06-24)")
    protected String fDataPath;
    private static final String DEFAULT_COLOR = "000000";
    private static final Pattern DATA_SET_PATTERN = Pattern.compile(".*?gmdata-(.*?)");
    @Option(name="--filename", required=true, usage="file containing object identifier information (e.g. gene symbols)")
    String fFilename;
    @Option(name="--taxid", usage="optional, taxonomy identifier for ids to import")
    Integer fTaxId;
    @Option(name="--name", required=true, usage="name of entity that identifiers belong to (e.g. organism)")
    String fName;
    @Option(name="--alias", usage="optional, alias of entity that identifiers belong to")
    String fAlias;
    @Option(name="--description", usage="optional, description of entity that identifiers belong to")
    String fDescription;
    @Option(name="--namespace")
    protected String fNamespaceName = "user";
    private IMania fMania;
    private Namespace fNamespace;

    private void initialize() throws ApplicationException, DataStoreException {
        try {
            File file;
            DataSetManager manager = IdImporter.createDataSetManager();
            if (this.fDataPath == null) {
                FileUtils fileUtils = new FileUtils();
                List<String> dataSets = fileUtils.getCompatibleDataSets("http://www.genemania.org/plugin", "1.1");
                String latestDataSet = dataSets.get(0);
                String id = this.getDataSetId(latestDataSet);
                String baseUrl = fileUtils.findDataSetBaseUrl("http://www.genemania.org/plugin", id);
                URL url = new URL(String.format("%s.zip", baseUrl));
                ProgressReporter progress = NullProgressReporter.instance();
                File dataZipFile = fileUtils.download(url, new File("."), progress);
                fileUtils.unzip(dataZipFile, dataZipFile.getParentFile(), progress);
                this.fDataPath = this.getDataPath(dataZipFile);
                dataZipFile.delete();
                System.err.printf("Warning: No data set was specified; creating a new one at: %s\n", this.fDataPath);
            }
            if (!manager.isDataSet(file = new File(this.fDataPath))) {
                throw new ApplicationException(String.format("%s is not a GeneMANIA data set", file));
            }
            this.fData = manager.open(file);
            DataCache cache = new DataCache((IObjectCache)new SynchronizedObjectCache((IObjectCache)new MemObjectCache(this.fData.getObjectCache(NullProgressReporter.instance(), false))));
            this.fMania = new Mania2(cache);
            this.fNamespace = this.fNamespaceName.equalsIgnoreCase("core") ? Namespace.CORE : Namespace.USER;
        }
        catch (SAXException e) {
            throw new ApplicationException((Throwable)e);
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    private String getDataPath(File zipFile) {
        String[] parts = zipFile.getPath().split(File.separator);
        String fileName = parts[parts.length - 1];
        int index = fileName.lastIndexOf(".");
        fileName = fileName.substring(0, index);
        String basePath = zipFile.getParent();
        return String.format("%s%s%s", basePath, File.separator, fileName);
    }

    public static void main(String[] args) throws Exception {
        IdImporter importer = new IdImporter();
        CmdLineParser parser = new CmdLineParser((Object)importer);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println(String.format("\nUsage: %s options\n", IdImporter.class.getSimpleName()));
            parser.printUsage((OutputStream)System.err);
            return;
        }
        importer.initialize();
        importer.importIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importIds() throws DataStoreException, ApplicationException, IOException {
        Organism organism = this.parseOrganism(this.fData, this.fName);
        if (organism != null) {
            throw new ApplicationException(String.format("Organism with name '%s' already exists in the data set", this.fName));
        }
        if (this.isEmpty(this.fAlias)) {
            this.fAlias = this.fName;
        }
        if (this.isEmpty(this.fDescription)) {
            this.fDescription = "";
        }
        organism = this.createOrganism();
        InteractionNetworkGroup group = this.createDefaultGroup();
        IdFileParser parser = new IdFileParser(this.fData, this.fNamespace);
        Set<Node> nodes = parser.parseNodes(new FileReader(this.fFilename), organism, NullProgressReporter.instance());
        IModelWriter writer = this.fData.createModelWriter();
        try {
            writer.addOrganism(organism);
            writer.addGroup(group, organism, DEFAULT_COLOR);
            for (Node node : nodes) {
                writer.addNode(node, organism);
            }
        }
        finally {
            writer.close();
        }
        AddOrganismEngineRequestDto request = new AddOrganismEngineRequestDto();
        request.setProgressReporter(NullProgressReporter.instance());
        request.setOrganismId(organism.getId());
        Collection<Long> nodeIds = parser.extractNodeIds(nodes);
        request.setNodeIds(nodeIds);
        this.fMania.addOrganism(request);
    }

    private InteractionNetworkGroup createDefaultGroup() throws ApplicationException {
        InteractionNetworkGroup group = new InteractionNetworkGroup();
        group.setId(this.fData.getNextAvailableId(InteractionNetworkGroup.class, this.fNamespace).longValue());
        group.setName("Other");
        group.setCode("other");
        group.setDescription("Other");
        return group;
    }

    private Organism createOrganism() throws ApplicationException {
        Organism organism = new Organism();
        organism.setName(this.fName);
        organism.setAlias(this.fAlias);
        organism.setDescription(this.fDescription);
        if (this.fTaxId != null) {
            organism.setTaxonomyId((long)this.fTaxId.intValue());
        } else {
            organism.setTaxonomyId(-1L);
        }
        organism.setId(this.fData.getNextAvailableId(organism.getClass(), this.fNamespace).longValue());
        return organism;
    }

    protected boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    private String getDataSetId(String url) {
        Matcher matcher = DATA_SET_PATTERN.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }
}

