/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import com.mysql.jdbc.Driver;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.apps.AbstractPluginApp;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class ValidationSetMaker
extends AbstractPluginApp {
    @Option(name="--organism", usage="taxonomy id of organism", required=true)
    private int fTaxonomyId;
    @Option(name="--db", usage="JDBC connection string for a GO database, defaults to EBI's MySQL GO mirror")
    String fConnectionString = "jdbc:mysql://mysql.ebi.ac.uk:4085/go_latest?user=go_select&password=amigo";
    @Option(name="--query", usage="name of the resulting query file", required=true)
    String fQueryFilename;
    @Option(name="--branch", usage="GO branch to consider (one of: 'all', 'bp', 'mf', 'cc').  Defaults to 'all'")
    String fBranch = "all";

    String createGoQuery(long taxId) {
        String ignoreClause = "and evidence.code not in ('IEA', 'ND', 'RCA')";
        return "select ancestor_term.term_type as ancestor_term_type, ancestor_term.acc as ancestor_acc, gene_product.symbol from association, term as ancestor_term, term as descendent_term, gene_product, species, evidence, graph_path, dbxref where species.ncbi_taxa_id = " + taxId + " and species.id = gene_product.species_id" + " and association.gene_product_id = gene_product.id" + " and ancestor_term.id = graph_path.term1_id" + " and descendent_term.id = graph_path.term2_id" + " and evidence.association_id = association.id " + ignoreClause + " and association.term_id = descendent_term.id" + " and gene_product.dbxref_id = dbxref.id" + " and association.is_not = 0" + " and descendent_term.is_obsolete = 0;";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeQuery() throws DataStoreException, ApplicationException, IOException {
        this.checkWritable(this.fQueryFilename);
        HashMap<String, String> branches = new HashMap<String, String>();
        branches.put("all", "all");
        branches.put("bp", "biological_process");
        branches.put("mf", "molecular_function");
        branches.put("cc", "cellular_component");
        String targetBranch = (String)branches.get(this.fBranch);
        if (targetBranch == null) {
            System.err.printf("Unrecognized GO branch: %s\n", this.fBranch);
            return;
        }
        String query = this.createGoQuery(this.fTaxonomyId);
        try {
            new Driver();
            System.out.println("Connecting...");
            Connection connection = DriverManager.getConnection(this.fConnectionString);
            Statement statement = connection.createStatement(1003, 1007);
            statement.setFetchSize(Integer.MIN_VALUE);
            long start = System.currentTimeMillis();
            System.out.println("Executing query...");
            ResultSet results = statement.executeQuery(query);
            PrintWriter writer = new PrintWriter(new File(this.fQueryFilename));
            try {
                long annotationsFetched = 0L;
                HashMap<String, HashSet<String>> allCategories = new HashMap<String, HashSet<String>>();
                try {
                    while (results.next()) {
                        if (++annotationsFetched % 1000L == 0L) {
                            System.out.printf("Fetched %d annotations...\n", annotationsFetched);
                        }
                        String branch = results.getString("ancestor_term_type");
                        String id = results.getString("ancestor_acc");
                        String gene = results.getString("symbol");
                        if (!targetBranch.equals("all") && !targetBranch.equals(branch)) continue;
                        HashSet<String> category = (HashSet<String>)allCategories.get(id);
                        if (category == null) {
                            category = new HashSet<String>();
                            allCategories.put(id, category);
                        }
                        category.add(gene);
                    }
                    ArrayList terms = new ArrayList(allCategories.keySet());
                    Collections.sort(terms);
                    int totalCategories = 0;
                    for (String term : terms) {
                        Set genes = (Set)allCategories.get(term);
                        ++totalCategories;
                        writer.print(term);
                        writer.print("\t");
                        writer.print("+");
                        for (String gene : genes) {
                            writer.print("\t");
                            writer.print(gene);
                        }
                        writer.println();
                    }
                    System.out.printf("Total GO categories: %d\n", totalCategories);
                    System.out.println("Done.");
                }
                catch (Throwable throwable) {
                    long duration = System.currentTimeMillis() - start;
                    System.out.printf("Elapsed time: %.2fs\n", (double)duration / 1000.0);
                    results.close();
                    connection.close();
                    throw throwable;
                }
                long duration = System.currentTimeMillis() - start;
                System.out.printf("Elapsed time: %.2fs\n", (double)duration / 1000.0);
                results.close();
                connection.close();
            }
            finally {
                writer.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ApplicationException((Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        ValidationSetMaker maker = new ValidationSetMaker();
        CmdLineParser parser = new CmdLineParser((Object)maker);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.printf("\nUsage: %s options\n\n", ValidationSetMaker.class.getSimpleName());
            parser.printUsage((OutputStream)System.err);
            return;
        }
        maker.makeQuery();
    }
}

