/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class DynamicTableModel<T>
implements TableModel {
    protected final List<T> items = new ArrayList<T>();
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public T get(int index) {
        return this.items.get(index);
    }

    public void add(T item) {
        this.items.add(item);
        int index = this.items.size() - 1;
        this.fireEvent(new TableModelEvent(this, index, index, -1, 1));
    }

    public boolean contains(T item) {
        return this.items.contains(item);
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void clear() {
        this.fireEvent(new TableModelEvent(this, 0, Math.max(0, this.items.size() - 1), -1, -1));
        this.items.clear();
    }

    public void removeRows(int[] indices) {
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            this.remove(indices[i]);
        }
    }

    public void remove(int index) {
        this.items.remove(index);
        this.fireEvent(new TableModelEvent(this, index, index, -1, -1));
    }

    void fireEvent(TableModelEvent event) {
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    public void sort(Comparator<? super T> comparator) {
        Collections.sort(this.items, comparator);
        this.fireEvent(new TableModelEvent(this, 0, Math.max(0, this.items.size() - 1), -1, 0));
    }
}

