/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.controllers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;

public class DownloadController {
    public static Pattern optionPattern = Pattern.compile("(\\d+-\\d+-\\d+)(-.+)?");
    private final DataSetManager dataSetManager;
    private final FileUtils fileUtils;

    public DownloadController(DataSetManager dataSetManager, FileUtils fileUtils) {
        this.dataSetManager = dataSetManager;
        this.fileUtils = fileUtils;
    }

    public List<ModelElement> createModel() throws IOException {
        Pattern pattern = Pattern.compile(".*?gmdata-(.*?)");
        List<File> paths = this.dataSetManager.getDataSetPaths();
        HashSet<String> alreadyInstalled = new HashSet<String>();
        for (File file : paths) {
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.matches()) continue;
            alreadyInstalled.add(matcher.group(1));
        }
        String activeDataId = null;
        DataSet data = this.dataSetManager.getDataSet();
        if (data != null) {
            activeDataId = data.getVersion().toString();
        }
        Map<String, String> descriptions = this.fileUtils.getDataSetDescriptions("http://www.genemania.org/plugin");
        Map<String, Long> sizes = this.fileUtils.getDataSetSizes("http://www.genemania.org/plugin");
        List<String> dataSets = this.fileUtils.getCompatibleDataSets("http://www.genemania.org/plugin", "1.1");
        ArrayList<ModelElement> model = new ArrayList<ModelElement>();
        HashMap parents = new HashMap();
        for (String url : dataSets) {
            Matcher matcher = pattern.matcher(url);
            if (!matcher.matches()) continue;
            String dataId = matcher.group(1);
            String description = descriptions.get(dataId);
            Long size = sizes.get(dataId);
            if (size == null) {
                size = 0L;
            }
            ModelElement element = new ModelElement(dataId, description, alreadyInstalled.contains(dataId), dataId.equals(activeDataId), size);
            Matcher childMatcher = optionPattern.matcher(dataId);
            if (childMatcher.matches() && childMatcher.group(2) != null) {
                List<ModelElement> children;
                String parent = childMatcher.group(1);
                if (parents.containsKey(parent)) {
                    children = (List)parents.get(parent);
                } else {
                    children = new ArrayList();
                    parents.put(parent, children);
                }
                children.add(element);
                continue;
            }
            model.add(element);
        }
        for (ModelElement parent : model) {
            String dataId = parent.getName();
            List children = (List)parents.get(dataId);
            if (children == null) continue;
            children.add(new ModelElement(parent.getName(), parent.getDescription(), parent.isInstalled(), parent.isActive(), parent.getSize()));
            ModelElement[] elements = children.toArray(new ModelElement[children.size()]);
            parent.setChildren(elements);
        }
        return model;
    }

    public static class ModelElement
    implements Comparable<ModelElement> {
        private static final ModelElement[] NO_CHILDREN = new ModelElement[0];
        private String name;
        private String description;
        private boolean installed;
        private boolean active;
        private ModelElement[] children;
        private long size;

        public ModelElement(String name, String description, boolean installed, boolean active, long size) {
            this.name = name;
            this.description = description == null ? "" : description;
            this.installed = installed;
            this.active = active;
            this.size = size;
            this.children = NO_CHILDREN;
        }

        public void setChildren(ModelElement[] children) {
            this.children = children == null ? NO_CHILDREN : children;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isInstalled() {
            if (this.children.length == 0) {
                return this.installed;
            }
            for (ModelElement element : this.children) {
                if (!element.installed) continue;
                return true;
            }
            return false;
        }

        public boolean isActive() {
            if (this.children.length == 0) {
                return this.active;
            }
            for (ModelElement element : this.children) {
                if (!element.active) continue;
                return true;
            }
            return false;
        }

        public long getSize() {
            return this.size;
        }

        public ModelElement[] getChildren() {
            return this.children;
        }

        @Override
        public int compareTo(ModelElement o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

