/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.genemania.data.classification.IGeneClassifier;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.domain.GeneNamingSource;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.data.Colour;
import org.genemania.plugin.data.DataDescriptor;
import org.genemania.plugin.data.IConfiguration;
import org.genemania.plugin.data.IMediatorProvider;
import org.genemania.plugin.data.IModelManager;
import org.genemania.plugin.data.IModelWriter;
import org.genemania.plugin.data.Namespace;
import org.genemania.plugin.data.Version;
import org.genemania.plugin.data.compatibility.AdapterStrategy1450;
import org.genemania.plugin.data.compatibility.AdapterStrategyObjectCache;
import org.genemania.util.ProgressReporter;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class DataSet {
    public static final String USER = "user";
    public static final String BASE = "base";
    public static final String CACHE_PATH = "cache";
    public static final String ACCESS_MODE_COMPACT = "compact";
    public static final String ACCESS_MODE_DIRECT = "direct";
    protected Version version;
    protected final File path;
    protected String accessMode;
    private boolean headlessMode;

    public DataSet(File path, Node root) throws SAXException {
        this.path = path;
        try {
            this.processConfiguration(root);
        }
        catch (XPathExpressionException e) {
            throw new SAXException(e);
        }
    }

    protected void processConfiguration(Node root) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        this.version = Version.parse(DataSet.getString(xpath, "data-version", root));
        this.accessMode = DataSet.getString(xpath, "access-mode", root);
    }

    public Version getVersion() {
        return this.version;
    }

    public String getAccessMode() {
        return this.accessMode;
    }

    protected static String getString(XPath xpath, String query, Node root) throws XPathExpressionException {
        String value = (String)xpath.evaluate(query, root, XPathConstants.STRING);
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    public String getDescription() {
        return this.version.toString();
    }

    public IObjectCache getObjectCache(ProgressReporter progress, boolean forceRebuild) throws ApplicationException, DataStoreException {
        String fullCachePath = this.getFullPath(CACHE_PATH);
        AdapterStrategyObjectCache cache = new AdapterStrategyObjectCache(fullCachePath);
        cache.addStrategy(new AdapterStrategy1450(this.getClassLoader("compatibility/1472/")));
        cache.addStrategy(new AdapterStrategy1450(this.getClassLoader("compatibility/1450/")));
        return cache;
    }

    ClassLoader getClassLoader(String root) {
        URL base = this.getClass().getClassLoader().getResource(root);
        return new URLClassLoader(new URL[]{base}, null);
    }

    public String getFullPath(String relativePath) {
        return DataSet.getFullPath(this.path.getPath(), relativePath);
    }

    static String getFullPath(String base, String path) {
        return String.format("%s%s%s", base, File.separator, path);
    }

    public String getBasePath() {
        return this.path.getPath();
    }

    public void log(Throwable e) {
        if (e == null) {
            return;
        }
        Logger logger = Logger.getLogger(this.getClass());
        logger.error((Object)"Unexpected error", e);
    }

    public boolean isHeadless() {
        return this.headlessMode;
    }

    public void setHeadless(boolean enabled) {
        this.headlessMode = enabled;
    }

    public abstract IConfiguration getConfiguration();

    public abstract IMediatorProvider getMediatorProvider();

    public abstract void reload(ProgressReporter var1) throws IOException;

    public abstract GeneCompletionProvider2 getCompletionProvider(Organism var1);

    public abstract Colour getColor(String var1);

    public abstract InteractionNetworkGroup getNetworkGroup(long var1);

    public abstract List<DataDescriptor> getInstalledDataDescriptors();

    public abstract List<Long> getNodeIds(long var1);

    public abstract List<GeneNamingSource> getAllNamingSources();

    public abstract IGeneClassifier getGeneClassifier();

    public abstract <T> Long getNextAvailableId(Class<T> var1, Namespace var2) throws ApplicationException;

    public abstract IModelWriter createModelWriter() throws ApplicationException;

    public abstract IModelManager createModelManager(Namespace var1) throws ApplicationException;

    public abstract Organism getOrganism(long var1);

    public abstract Collection<InteractionNetwork> getUserNetworks() throws ApplicationException;
}

