/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.data.Configuration;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.lucene.LuceneDataSet;
import org.genemania.plugin.data.lucene.view.LuceneConfigPanel;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.components.WrappedOptionPane;
import org.genemania.plugin.view.util.UiUtils;

public class LuceneConfiguration<NETWORK, NODE, EDGE>
extends Configuration {
    private JDialog dialog;
    private final DataSetManager dataSetManager;
    private final UiUtils uiUtils;
    private final FileUtils fileUtils;
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;
    private final TaskDispatcher taskDispatcher;

    public LuceneConfiguration(DataSet data, DataSetManager dataSetManager, UiUtils uiUtils, FileUtils fileUtils, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils, TaskDispatcher taskDispatcher) {
        super(data);
        this.dataSetManager = dataSetManager;
        this.uiUtils = uiUtils;
        this.fileUtils = fileUtils;
        this.cytoscapeUtils = cytoscapeUtils;
        this.taskDispatcher = taskDispatcher;
    }

    @Override
    public boolean hasUi() {
        return true;
    }

    @Override
    public void showUi(Window parent) {
        if (parent instanceof Frame) {
            this.dialog = new JDialog((Frame)parent, true);
        } else if (parent instanceof Dialog) {
            this.dialog = new JDialog((Dialog)parent, true);
        } else {
            return;
        }
        final LuceneConfigPanel<NETWORK, NODE, EDGE> configPanel = new LuceneConfigPanel<NETWORK, NODE, EDGE>((LuceneDataSet)this.data, this.dataSetManager, this.uiUtils, this.fileUtils, this.cytoscapeUtils, this.taskDispatcher);
        this.dialog.setTitle(Strings.dataSetConfiguration_title);
        this.dialog.setPreferredSize(new Dimension(650, 600));
        this.dialog.setLayout(new GridBagLayout());
        this.dialog.add(configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton closeButton = new JButton(Strings.closeButton_label);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LuceneConfiguration.this.confirmClose(configPanel.getDataSet());
            }
        });
        this.dialog.add((Component)closeButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 24, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LuceneConfiguration.this.confirmClose(configPanel.getDataSet());
            }
        });
        this.dialog.setLocationByPlatform(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
        configPanel.close();
    }

    private void confirmClose(DataSet data) {
        try {
            List organisms = data.getMediatorProvider().getOrganismMediator().getAllOrganisms();
            if (organisms.size() == 0) {
                if (WrappedOptionPane.showConfirmDialog((Component)this.dialog, Strings.luceneConfig_error, Strings.luceneConfig_title, 0, 2, 40) == 0) {
                    this.dialog.setVisible(false);
                }
            } else {
                this.dialog.setVisible(false);
            }
        }
        catch (DataStoreException e) {
            LogUtils.log(this.getClass(), e);
            this.dialog.setVisible(false);
        }
    }
}

