/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.genemania.domain.Gene;
import org.genemania.domain.GeneData;
import org.genemania.domain.GeneNamingSource;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.NetworkMetadata;
import org.genemania.domain.Node;
import org.genemania.domain.Ontology;
import org.genemania.domain.Organism;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.lucene.AbstractCollector;
import org.genemania.mediator.lucene.exporter.Generic2LuceneExporter;
import org.genemania.plugin.data.IModelWriter;

public class LuceneModelWriter
implements IModelWriter {
    private final IndexWriter writer;
    private final Generic2LuceneExporter exporter;

    public LuceneModelWriter(IndexWriter indexWriter) {
        this.writer = indexWriter;
        this.exporter = new Generic2LuceneExporter();
    }

    @Override
    public void close() throws ApplicationException {
        try {
            this.writer.commit();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addNetwork(InteractionNetwork network, InteractionNetworkGroup group) throws ApplicationException {
        NetworkMetadata metadata = network.getMetadata();
        try {
            this.exporter.exportNetwork(this.writer, new String[]{String.valueOf(network.getId()), network.getName(), String.valueOf(metadata.getId()), network.getDescription(), network.isDefaultSelected() ? "true" : "0", String.valueOf(group.getId())});
            this.exporter.exportNetworkMetadata(this.writer, new String[]{String.valueOf(metadata.getId()), this.filter(metadata.getSource()), this.filter(metadata.getReference()), this.filter(metadata.getPubmedId()), this.filter(metadata.getAuthors()), this.filter(metadata.getPublicationName()), this.filter(metadata.getYearPublished()), this.filter(metadata.getProcessingDescription()), this.filter(metadata.getNetworkType()), this.filter(metadata.getAlias()), String.valueOf(metadata.getInteractionCount()), this.filter(metadata.getDynamicRange()), this.filter(metadata.getEdgeWeightDistribution()), String.valueOf(metadata.getAccessStats()), this.filter(metadata.getComment()), this.filter(metadata.getOther()), this.filter(metadata.getTitle()), this.filter(metadata.getUrl()), this.filter(metadata.getSourceUrl())});
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    @Override
    public void addGroup(InteractionNetworkGroup group, Organism organism, String colour) throws ApplicationException {
        try {
            HashMap<String, String> colourMap = new HashMap<String, String>();
            colourMap.put(group.getCode(), colour);
            this.exporter.setNetworkGroupColours(colourMap);
            this.exporter.exportGroup(this.writer, new String[]{String.valueOf(group.getId()), group.getName(), group.getCode(), group.getDescription(), String.valueOf(organism.getId())});
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    @Override
    public void addOrganism(Organism organism) throws ApplicationException {
        try {
            Ontology ontology = organism.getOntology();
            long ontologyId = ontology == null ? -1L : ontology.getId();
            this.exporter.exportOrganism(this.writer, new String[]{String.valueOf(organism.getId()), organism.getName(), this.filter(organism.getDescription()), organism.getAlias(), String.valueOf(ontologyId), String.valueOf(organism.getTaxonomyId())});
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    @Override
    public void addNode(Node node, Organism organism) throws ApplicationException {
        GeneData geneData = node.getGeneData();
        try {
            this.exporter.exportNode(this.writer, new String[]{String.valueOf(node.getId()), node.getName(), String.valueOf(geneData.getId())}, String.valueOf(organism.getId()));
            this.addGeneData(this.writer, geneData);
            for (Gene gene : node.getGenes()) {
                this.addGene(gene);
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    @Override
    public void addGene(Gene gene) throws ApplicationException {
        GeneNamingSource namingSource = gene.getNamingSource();
        long namingSourceId = namingSource == null ? 0L : namingSource.getId();
        try {
            this.exporter.exportGene(this.writer, new String[]{String.valueOf(gene.getId()), gene.getSymbol(), null, String.valueOf(namingSourceId), String.valueOf(gene.getNode().getId()), String.valueOf(gene.getOrganism().getId()), String.valueOf(gene.isDefaultSelected())});
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    void addGeneData(IndexWriter writer, GeneData data) throws IOException {
        GeneNamingSource namingSource = data.getLinkoutSource();
        long namingSourceId = namingSource == null ? 0L : namingSource.getId();
        this.exporter.exportGeneData(writer, new String[]{String.valueOf(data.getId()), this.filter(data.getDescription())}, data.getExternalId(), namingSourceId);
    }

    private String filter(String value) {
        return value == null ? "" : value;
    }

    @Override
    public void addNamingSource(GeneNamingSource source) throws ApplicationException {
        try {
            this.exporter.exportNamingSource(this.writer, new String[]{String.valueOf(source.getId()), source.getName(), String.valueOf(source.getRank()), source.getShortName()});
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNetwork(InteractionNetwork network) throws ApplicationException {
        try {
            try {
                this.writer.deleteDocuments((Query)new TermQuery(new Term("network_id", String.valueOf(network.getId()))));
                NetworkMetadata metadata = network.getMetadata();
                if (metadata != null) {
                    this.writer.deleteDocuments((Query)new TermQuery(new Term("metadata_id", String.valueOf(metadata.getId()))));
                }
            }
            finally {
                this.writer.commit();
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOrganism(Organism organism) throws ApplicationException {
        try {
            try {
                this.writer.deleteDocuments((Query)new TermQuery(new Term("organism_id", String.valueOf(organism.getId()))));
            }
            finally {
                this.writer.commit();
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOrganismNodesAndGenes(Organism organism) throws ApplicationException {
        try {
            try {
                IndexReader reader = this.writer.getReader();
                IndexSearcher searcher = new IndexSearcher(reader);
                HashSet nodeIds = new HashSet();
                HashSet geneIds = new HashSet();
                HashSet geneDataIds = new HashSet();
                try {
                    searcher.search((Query)new TermQuery(new Term("node_organism_id", String.valueOf(organism.getId()))), (Collector)new AbstractCollector((Searcher)searcher, nodeIds, geneDataIds){
                        final /* synthetic */ Searcher val$searcher;
                        final /* synthetic */ Set val$nodeIds;
                        final /* synthetic */ Set val$geneDataIds;
                        {
                            this.val$searcher = searcher;
                            this.val$nodeIds = set;
                            this.val$geneDataIds = set2;
                        }

                        public void handleHit(int doc) throws IOException {
                            Document document = this.val$searcher.doc(doc);
                            this.val$nodeIds.add(Long.parseLong(document.get("node_id")));
                            this.val$geneDataIds.add(Long.parseLong(document.get("node_genedata_id")));
                        }
                    });
                    searcher.search((Query)new TermQuery(new Term("gene_organism_id", String.valueOf(organism.getId()))), (Collector)new AbstractCollector((Searcher)searcher, geneIds){
                        final /* synthetic */ Searcher val$searcher;
                        final /* synthetic */ Set val$geneIds;
                        {
                            this.val$searcher = searcher;
                            this.val$geneIds = set;
                        }

                        public void handleHit(int doc) throws IOException {
                            Document document = this.val$searcher.doc(doc);
                            this.val$geneIds.add(Long.parseLong(document.get("gene_id")));
                        }
                    });
                }
                finally {
                    searcher.close();
                }
                for (Long geneDataId : geneDataIds) {
                    this.writer.deleteDocuments((Query)new TermQuery(new Term("genedata_id", String.valueOf(geneDataId))));
                }
                for (Long geneId : geneIds) {
                    this.writer.deleteDocuments((Query)new TermQuery(new Term("gene_id", String.valueOf(geneId))));
                }
                for (Long nodeId : nodeIds) {
                    this.writer.deleteDocuments((Query)new TermQuery(new Term("node_id", String.valueOf(nodeId))));
                }
                this.writer.deleteDocuments((Query)new TermQuery(new Term("organism_id", String.valueOf(organism.getId()))));
            }
            finally {
                this.writer.commit();
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }
}

