/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.genemania.domain.Organism;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.OrganismMediator;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.completion.DynamicTableModel;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetChangeListener;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.Namespace;
import org.genemania.plugin.data.lucene.LuceneDataSet;
import org.genemania.plugin.data.lucene.controllers.ImportOrganismController;
import org.genemania.plugin.data.lucene.view.EditOrganismDialog;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.validation.OrganismValidator;
import org.genemania.plugin.view.util.FileSelectionMode;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.util.ProgressReporter;

public class ImportOrganismPanel
extends JPanel {
    private final DataSetManager dataSetManager;
    private final FileUtils fileUtils;
    private final UiUtils uiUtils;
    private final ImportOrganismController controller;
    private final OrganismValidator validator;
    private JTextField fileField;
    private JTextField nameField;
    private JTextField aliasField;
    private JTextField taxIdField;
    private JTextArea descriptionField;
    private JButton importButton;
    private DataSetChangeListener listener;
    private JTable installedTable;
    private JButton editButton;
    private JButton deleteButton;
    private DynamicTableModel<Organism> installedModel;

    public ImportOrganismPanel(DataSetManager dataSetManager, FileUtils fileUtils, UiUtils uiUtils, TaskDispatcher taskDispatcher) {
        this.dataSetManager = dataSetManager;
        this.fileUtils = fileUtils;
        this.uiUtils = uiUtils;
        this.controller = new ImportOrganismController(dataSetManager, taskDispatcher);
        this.validator = new OrganismValidator();
        DataSet data = dataSetManager.getDataSet();
        this.listener = new DataSetChangeListener(){

            @Override
            public void dataSetChanged(DataSet activeDataSet, ProgressReporter progress) {
                ImportOrganismPanel.this.handleDataSetChange(activeDataSet);
            }
        };
        dataSetManager.addDataSetChangeListener(this.listener);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        JPanel importPanel = this.createImportPanel();
        JPanel installedPanel = this.createInstalledPanel();
        Insets insets = new Insets(0, 0, 0, 0);
        this.add((Component)importPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        this.add((Component)installedPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        this.handleDataSetChange(data);
        this.validateSettings();
    }

    private void handleDataSetChange(DataSet data) {
        this.installedModel.clear();
        OrganismMediator mediator = data.getMediatorProvider().getOrganismMediator();
        try {
            List organisms = mediator.getAllOrganisms();
            for (Organism organism : organisms) {
                if (organism.getId() >= 0L) continue;
                this.installedModel.add(organism);
            }
            this.uiUtils.packColumns(this.installedTable);
            this.validator.setOrganisms(organisms);
        }
        catch (DataStoreException e) {
            LogUtils.log(this.getClass(), e);
        }
    }

    private JPanel createInstalledPanel() {
        JPanel panel = this.uiUtils.createJPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(Strings.installedOrganismList_title));
        final LuceneDataSet data = (LuceneDataSet)this.dataSetManager.getDataSet();
        this.installedModel = this.controller.createModel(data);
        this.installedTable = new JTable(this.installedModel){

            @Override
            public void addNotify() {
                super.addNotify();
                ImportOrganismPanel.this.uiUtils.packColumns(ImportOrganismPanel.this.installedTable);
            }
        };
        this.installedTable.setOpaque(false);
        this.installedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int totalSelected = ImportOrganismPanel.this.installedTable.getSelectedRowCount();
                ImportOrganismPanel.this.editButton.setEnabled(totalSelected == 1);
                ImportOrganismPanel.this.deleteButton.setEnabled(totalSelected > 0);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.installedTable);
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.deleteButton = new JButton(Strings.deleteNetworkButton_label);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImportOrganismPanel.this.deleteOrganisms(data);
            }
        });
        this.deleteButton.setEnabled(false);
        this.editButton = new JButton(Strings.editNetworkButton_label);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImportOrganismPanel.this.editOrganisms(data);
            }
        });
        this.editButton.setEnabled(false);
        panel.add((Component)this.deleteButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.editButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createImportPanel() {
        JPanel panel = this.uiUtils.createJPanel();
        panel.setBorder(BorderFactory.createTitledBorder(Strings.importOrganism_title));
        panel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        int row = 0;
        int rowWidth = 3;
        JLabel header = new JLabel(Strings.importOrganismHelp_label);
        panel.add((Component)header, new GridBagConstraints(0, row, rowWidth, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        ++row;
        DocumentListener listener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImportOrganismPanel.this.validateSettings();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImportOrganismPanel.this.validateSettings();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImportOrganismPanel.this.validateSettings();
            }
        };
        this.fileField = new JTextField();
        this.fileField.getDocument().addDocumentListener(listener);
        this.fileField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ImportOrganismPanel.this.validateSettings();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        JButton browseButton = new JButton(Strings.importOrganismBrowseButton_label);
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOrganismPanel.this.handleBrowse();
            }
        });
        panel.add((Component)new JLabel(Strings.importOrganismFile_label), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        panel.add((Component)this.fileField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        panel.add((Component)browseButton, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.nameField = new JTextField(30);
        this.nameField.getDocument().addDocumentListener(listener);
        panel.add((Component)new JLabel(Strings.importOrganismName_label), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        panel.add((Component)this.nameField, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.aliasField = new JTextField(30);
        this.aliasField.getDocument().addDocumentListener(listener);
        panel.add((Component)new JLabel(Strings.importOrganismAlias_label), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        panel.add((Component)this.aliasField, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.taxIdField = new JTextField(30);
        this.taxIdField.getDocument().addDocumentListener(listener);
        panel.add((Component)new JLabel(Strings.importOrganismTaxonomyId_label), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        panel.add((Component)this.taxIdField, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.descriptionField = new JTextArea();
        this.descriptionField.getDocument().addDocumentListener(listener);
        panel.add((Component)new JLabel(Strings.importOrganismDescription_label), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 24, 0, insets, 0, 0));
        panel.add((Component)new JScrollPane(this.descriptionField), new GridBagConstraints(1, row, 2, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        this.importButton = new JButton(Strings.importOrganismImportButton_label);
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOrganismPanel.this.handleImport();
            }
        });
        panel.add((Component)this.importButton, new GridBagConstraints(0, ++row, rowWidth, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        ++row;
        return panel;
    }

    private void handleBrowse() {
        File file;
        HashSet<String> extensions = new HashSet<String>();
        extensions.add("csv");
        extensions.add("txt");
        File initialFile = this.fileUtils.getUserHome();
        try {
            file = this.uiUtils.getFile(this.uiUtils.getFrame(this), Strings.importNetworkFile_title, initialFile, Strings.importNetworkPanelTypeDescription_label, extensions, FileSelectionMode.OPEN_FILE);
        }
        catch (ApplicationException e) {
            LogUtils.log(this.getClass(), e);
            return;
        }
        if (file == null) {
            return;
        }
        this.fileField.setText(file.getAbsolutePath());
        this.validateSettings();
    }

    private void handleImport() {
        DataSet data = this.dataSetManager.getDataSet();
        Organism organism = new Organism();
        try {
            organism.setId(data.getNextAvailableId(organism.getClass(), Namespace.USER).longValue());
            organism.setName(this.nameField.getText());
            organism.setAlias(this.aliasField.getText());
            organism.setTaxonomyId(this.getTaxonomyId());
            organism.setDescription(this.descriptionField.getText());
            FileReader reader = new FileReader(this.fileField.getText());
            this.controller.importOrganism(this.uiUtils.getFrame(this), data, reader, organism);
            this.resetFields();
        }
        catch (ApplicationException e) {
            LogUtils.log(this.getClass(), e);
        }
        catch (IOException e) {
            LogUtils.log(this.getClass(), e);
        }
    }

    private void resetFields() {
        this.fileField.setText("");
        this.nameField.setText("");
        this.aliasField.setText("");
        this.taxIdField.setText("");
        this.descriptionField.setText("");
    }

    private long getTaxonomyId() {
        String text = this.taxIdField.getText();
        if (text == null || text.isEmpty()) {
            return -1L;
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private void deleteOrganisms(LuceneDataSet data) {
        int[] selection = this.installedTable.getSelectedRows();
        this.controller.deleteOrganisms(this.uiUtils.getFrame(this), data, this.installedModel, selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editOrganisms(DataSet data) {
        int[] selection;
        for (int index : selection = this.installedTable.getSelectedRows()) {
            EditOrganismDialog dialog;
            Organism organism = this.installedModel.get(index);
            try {
                this.validator.setCurrentOrganism(organism);
                dialog = new EditOrganismDialog(this.uiUtils.getFrame(this), true, this.uiUtils, this.validator);
                dialog.setLocationByPlatform(true);
                dialog.setOrganismName(organism.getName());
                dialog.setAlias(organism.getAlias());
                dialog.setTaxonomyId(organism.getTaxonomyId());
                dialog.setDescription(organism.getDescription());
                dialog.validateSettings();
                dialog.pack();
                dialog.setVisible(true);
            }
            finally {
                this.validator.setCurrentOrganism(null);
            }
            if (dialog.isCanceled()) {
                return;
            }
            organism.setName(dialog.getOrganismName());
            organism.setAlias(dialog.getAlias());
            organism.setTaxonomyId(dialog.getTaxonomyId());
            organism.setDescription(dialog.getDescription());
            this.controller.updateOrganism(this.uiUtils.getFrame(this), data, organism);
        }
    }

    private void validateSettings() {
        boolean isValid = true;
        isValid &= this.isValidPath(this.fileField.getText());
        isValid &= this.validator.isValidName(this.nameField.getText());
        isValid &= this.validator.isValidAlias(this.aliasField.getText());
        this.importButton.setEnabled(isValid &= this.validator.isValidTaxonomyId(this.taxIdField.getText()));
    }

    private boolean isValidPath(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        return new File(path).isFile();
    }

    public void close() {
        this.dataSetManager.removeDataSetChangeListener(this.listener);
    }
}

