/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.genemania.data.normalizer.DataFileType;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.completion.DynamicTableModel;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetChangeListener;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.lucene.controllers.ImportedDataController;
import org.genemania.plugin.data.lucene.models.UserNetworkEntry;
import org.genemania.plugin.data.lucene.view.EditNetworkDialog;
import org.genemania.plugin.data.lucene.view.ImportNetworkPanel;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.validation.ValidationEventListener;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.util.ProgressReporter;

public class ImportedNetworkDataPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ImportedDataController controller;
    private final UiUtils uiUtils;
    private final DataSetManager dataSetManager;
    private final DataSetChangeListener listener;
    private DynamicTableModel<UserNetworkEntry> installedModel;
    private JTable installedTable;
    private JButton deleteButton;
    private JButton editButton;
    private ImportNetworkPanel importPanel;
    private JPanel importTabPanel;
    private JLabel helpLabel;
    private JPanel installedPanel;

    public ImportedNetworkDataPanel(DataSetManager dataSetManager, final UiUtils uiUtils, FileUtils fileUtils, TaskDispatcher taskDispatcher) {
        this.uiUtils = uiUtils;
        this.dataSetManager = dataSetManager;
        this.controller = new ImportedDataController(dataSetManager, taskDispatcher);
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.installedPanel = uiUtils.createJPanel();
        this.installedPanel.setLayout(new GridBagLayout());
        this.installedPanel.setBorder(BorderFactory.createTitledBorder(Strings.installedNetworkList_title));
        final DataSet data = dataSetManager.getDataSet();
        this.installedModel = this.controller.createModel(data);
        this.installedTable = new JTable(this.installedModel){

            @Override
            public void addNotify() {
                super.addNotify();
                uiUtils.packColumns(ImportedNetworkDataPanel.this.installedTable);
            }
        };
        this.installedTable.setOpaque(false);
        this.installedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int totalSelected = ImportedNetworkDataPanel.this.installedTable.getSelectedRowCount();
                ImportedNetworkDataPanel.this.editButton.setEnabled(totalSelected == 1);
                ImportedNetworkDataPanel.this.deleteButton.setEnabled(totalSelected > 0);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.installedTable);
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.installedPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.deleteButton = new JButton(Strings.deleteNetworkButton_label);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImportedNetworkDataPanel.this.deleteNetworks(data);
            }
        });
        this.deleteButton.setEnabled(false);
        this.editButton = new JButton(Strings.editNetworkButton_label);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImportedNetworkDataPanel.this.editNetworks(data);
            }
        });
        this.editButton.setEnabled(false);
        this.installedPanel.add((Component)this.deleteButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.installedPanel.add((Component)this.editButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.importTabPanel = uiUtils.createJPanel();
        this.importTabPanel.setLayout(new GridBagLayout());
        this.importTabPanel.setBorder(BorderFactory.createTitledBorder(Strings.importNetworkTab_label));
        this.importPanel = new ImportNetworkPanel(dataSetManager, uiUtils, fileUtils, taskDispatcher);
        this.updateOrganisms(data);
        this.helpLabel = new JLabel(Strings.luceneConfigUserDefinedTab_label);
        this.listener = new DataSetChangeListener(){

            @Override
            public void dataSetChanged(DataSet activeDataSet, ProgressReporter progress) {
                ImportedNetworkDataPanel.this.handleDataSetChange(activeDataSet);
            }
        };
        dataSetManager.addDataSetChangeListener(this.listener);
        int row = 0;
        this.importTabPanel.add((Component)this.importPanel, new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JButton importButton = new JButton(Strings.importNetworkButton_label);
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImportedNetworkDataPanel.this.importNetwork(data);
            }
        });
        this.importTabPanel.add((Component)importButton, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ++row;
        this.importPanel.addValidationEventListener(new ValidationEventListener(){

            @Override
            public void validate(boolean isValid) {
                importButton.setEnabled(isValid);
            }
        });
        this.importPanel.validateSettings();
        row = 0;
        this.add((Component)this.helpLabel, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.importTabPanel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.installedPanel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)uiUtils.createJPanel(), new GridBagConstraints(0, ++row, 1, 1, 0.0, Double.MIN_VALUE, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        ++row;
        this.handleDataSetChange(data);
    }

    private void handleDataSetChange(DataSet activeDataSet) {
        this.updateOrganisms(activeDataSet);
        if (activeDataSet != null) {
            boolean hasData = this.controller.hasData(activeDataSet);
            this.importTabPanel.setVisible(hasData);
            this.installedPanel.setVisible(hasData);
            if (hasData) {
                this.helpLabel.setText(Strings.luceneConfigUserDefinedTab_label);
            } else {
                this.helpLabel.setText(Strings.luceneConfigUserDefinedTab_label2);
            }
        }
        this.installedModel = this.controller.createModel(activeDataSet);
        this.installedTable.setModel(this.installedModel);
        this.uiUtils.packColumns(this.installedTable);
    }

    private void deleteNetworks(DataSet data) {
        int[] selection = this.installedTable.getSelectedRows();
        this.controller.deleteNetworks(this.uiUtils.getFrame(this), data, this.installedModel, selection);
    }

    private void editNetworks(DataSet data) {
        int[] selection;
        for (int index : selection = this.installedTable.getSelectedRows()) {
            UserNetworkEntry entry = this.installedModel.get(index);
            InteractionNetwork network = entry.network;
            EditNetworkDialog dialog = new EditNetworkDialog(this.uiUtils.getFrame(this), true, this.uiUtils);
            dialog.setLocationByPlatform(true);
            dialog.setOrganism(entry.organism);
            dialog.setGroup(entry.group);
            dialog.setNetworkName(network.getName());
            dialog.setDescription(network.getDescription());
            dialog.validateSettings();
            dialog.pack();
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return;
            }
            network.setName(dialog.getNetworkName());
            network.setDescription(dialog.getDescription());
            InteractionNetworkGroup group = dialog.getGroup();
            if (group.getId() == -1L) {
                String name = dialog.getGroupName();
                group.setName(name);
                group.setCode(name);
                group.setDescription("");
            }
            this.controller.updateNetwork(this.uiUtils.getFrame(this), data, network, group, dialog.getColor());
        }
    }

    private void importNetwork(DataSet data) {
        File file = this.importPanel.getNetworkFile();
        if (file == null || !file.exists()) {
            return;
        }
        String networkFile = file.getAbsolutePath();
        DataImportSettings settings = this.importPanel.getImportSettings();
        settings.setSource(file.getName());
        DataFileType type = this.importPanel.getType();
        this.controller.importNetwork(this.uiUtils.getFrame(this), data, settings, networkFile, type);
        this.uiUtils.packColumns(this.installedTable);
        this.importPanel.clear();
    }

    public void close() {
        this.dataSetManager.removeDataSetChangeListener(this.listener);
    }

    private void updateOrganisms(DataSet data) {
        List<Organism> organisms = this.controller.getOrganisms(data);
        this.importPanel.setOrganisms(organisms);
    }

    public DataSet getDataSet() {
        return this.dataSetManager.getDataSet();
    }
}

