/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.lucene.LuceneDataSet;
import org.genemania.plugin.data.lucene.view.ImportCyNetworkPanel;
import org.genemania.plugin.data.lucene.view.ImportedDataPanel;
import org.genemania.plugin.data.lucene.view.NetManiaPanel;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.util.UiUtils;

public class LuceneConfigPanel<NETWORK, NODE, EDGE>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ImportedDataPanel importedDataPanel;
    private final DataSetManager dataSetManager;

    public LuceneConfigPanel(LuceneDataSet<NETWORK, NODE, EDGE> data, DataSetManager dataSetManager, UiUtils uiUtils, FileUtils fileUtils, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils, TaskDispatcher taskDispatcher) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.dataSetManager = dataSetManager;
        this.importedDataPanel = new ImportedDataPanel(dataSetManager, uiUtils, fileUtils, taskDispatcher);
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab(Strings.luceneConfigNetManiaTab_title, new NetManiaPanel(dataSetManager, uiUtils, taskDispatcher));
        tabs.addTab(Strings.luceneConfigUserDefinedTab_title, this.importedDataPanel);
        tabs.addTab(Strings.luceneConfigCyNetworkTab_title, new ImportCyNetworkPanel<NETWORK, NODE, EDGE>(dataSetManager, uiUtils, cytoscapeUtils, taskDispatcher));
        this.add((Component)tabs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.validate();
    }

    public void close() {
        this.importedDataPanel.close();
    }

    public DataSet getDataSet() {
        return this.dataSetManager.getDataSet();
    }
}

