/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.delegates;

import java.util.Set;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.delegates.SelectionDelegate;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.proxies.NodeProxy;
import org.genemania.plugin.selection.NetworkSelectionManager;

public class NodeSetSelectionDelegate<NETWORK, NODE, EDGE>
extends SelectionDelegate<NETWORK, NODE, EDGE> {
    private final Set<NODE> nodes;

    public NodeSetSelectionDelegate(Set<NODE> nodes, boolean selected, NETWORK network, NetworkSelectionManager<NETWORK, NODE, EDGE> manager, GeneMania<NETWORK, NODE, EDGE> plugin, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils) {
        super(selected, network, manager, plugin, cytoscapeUtils);
        this.nodes = nodes;
    }

    @Override
    protected void handleSelection(ViewState options) throws ApplicationException {
        for (NODE node : this.nodes) {
            NodeProxy<NODE> nodeProxy = this.cytoscapeUtils.getNodeProxy(node, this.network);
            String name = nodeProxy.getAttribute("gene name", String.class);
            options.setGeneHighlighted(name, this.selected);
        }
    }
}

