/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.genemania.domain.Gene;
import org.genemania.domain.GeneData;
import org.genemania.domain.GeneNamingSource;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.Strings;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.IModelWriter;
import org.genemania.plugin.data.Namespace;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;

public class IdFileParser {
    private static final String USER_NAMING_SOURCE = "user";
    private final DataSet fData;
    private final Namespace fNamespace;

    public IdFileParser(DataSet data, Namespace namespace) {
        this.fData = data;
        this.fNamespace = namespace;
    }

    public Set<Node> parseNodes(Reader source, Organism organism, ProgressReporter progress) throws IOException, ApplicationException {
        List<GeneNamingSource> sources = this.fData.getAllNamingSources();
        GeneNamingSource userNamingSource = this.getUserNamingSource(sources);
        GeneNamingSource synonymNamingSource = this.getSynonymNamingSource(sources);
        BufferedReader reader = new BufferedReader(source);
        String line = reader.readLine();
        long nodeId = 1L;
        long geneDataId = this.fData.getNextAvailableId(GeneData.class, this.fNamespace);
        long geneId = this.fData.getNextAvailableId(Gene.class, this.fNamespace);
        HashSet<Node> nodes = new HashSet<Node>();
        while (line != null) {
            String[] parts = line.split("\t");
            Node node = new Node();
            node.setId(nodeId);
            node.setName(parts[0]);
            HashSet<Gene> genes = new HashSet<Gene>();
            node.setGenes(genes);
            boolean first = true;
            for (String symbol : parts) {
                Gene gene = new Gene();
                if (first) {
                    first = false;
                    gene.setNamingSource(userNamingSource);
                } else {
                    gene.setNamingSource(synonymNamingSource);
                }
                gene.setId(geneId);
                gene.setSymbol(symbol);
                gene.setNode(node);
                gene.setOrganism(organism);
                genes.add(gene);
                if (this.fNamespace == Namespace.USER) {
                    --geneId;
                    continue;
                }
                ++geneId;
            }
            GeneData data = new GeneData();
            data.setId(geneDataId);
            data.setDescription(parts[0]);
            node.setGeneData(data);
            nodes.add(node);
            progress.setDescription(String.format(Strings.idFileParser_status, nodes.size()));
            ++nodeId;
            geneDataId = this.fNamespace == Namespace.USER ? --geneDataId : ++geneDataId;
            line = reader.readLine();
        }
        return nodes;
    }

    private GeneNamingSource getUserNamingSource(List<GeneNamingSource> sources) throws ApplicationException, IOException {
        for (GeneNamingSource source : sources) {
            if (!source.getShortName().equals(USER_NAMING_SOURCE)) continue;
            return source;
        }
        return this.createUserNamingSource();
    }

    private GeneNamingSource getSynonymNamingSource(List<GeneNamingSource> sources) {
        for (GeneNamingSource source : sources) {
            if (!source.getShortName().equalsIgnoreCase("synonym")) continue;
            return source;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GeneNamingSource createUserNamingSource() throws ApplicationException, IOException {
        GeneNamingSource source = new GeneNamingSource();
        source.setId(this.fData.getNextAvailableId(GeneNamingSource.class, this.fNamespace).longValue());
        source.setName(USER_NAMING_SOURCE);
        source.setRank((byte)127);
        source.setShortName(USER_NAMING_SOURCE);
        IModelWriter writer = this.fData.createModelWriter();
        try {
            writer.addNamingSource(source);
        }
        finally {
            writer.close();
        }
        this.fData.reload(NullProgressReporter.instance());
        return source;
    }

    public Collection<Long> extractNodeIds(Set<Node> nodes) {
        HashSet<Long> ids = new HashSet<Long>();
        for (Node node : nodes) {
            ids.add(node.getId());
        }
        return ids;
    }
}

