/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.parsers;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.OneUseIterable;
import org.genemania.plugin.Strings;
import org.genemania.plugin.apps.IQueryErrorHandler;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.impl.InteractionNetworkGroupImpl;
import org.genemania.plugin.model.impl.InteractionNetworkImpl;
import org.genemania.plugin.parsers.AbstractQueryParser;
import org.genemania.plugin.parsers.Query;
import org.genemania.type.ScoringMethod;

public class JsonQueryParser
extends AbstractQueryParser {
    @Override
    public Query parse(DataSet data, Reader reader, IQueryErrorHandler handler) throws IOException {
        JsonNode root;
        Query query = new Query();
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        JsonParser parser = jsonFactory.createJsonParser(reader);
        try {
            root = parser.readValueAsTree();
        }
        catch (IOException e) {
            throw new IOException(Strings.jsonQueryParser_error, e);
        }
        try {
            Organism organism = this.parseOrganism(data, root.get("organism").getTextValue());
            query.setOrganism(organism);
            query.setCombiningMethod(this.parseCombiningMethod(root.get("selectedWeighting").getTextValue(), query, handler));
            query.setGeneLimit(root.get("numberOfResultGenes").getIntValue());
            query.setGenes(this.parseGenes(data, root.get("genes")));
            query.setNetworks(this.parseNetworks(data, root.get("networks"), organism));
            query.setScoringMethod(ScoringMethod.DISCRIMINANT);
        }
        catch (DataStoreException e) {
            throw new IOException(e.getMessage());
        }
        return query;
    }

    private Collection<Group<?, ?>> parseNetworks(DataSet data, JsonNode root, Organism organism) {
        List allGroups = data.getMediatorProvider().getNetworkMediator().getNetworkGroupsByOrganism(organism.getId());
        ArrayList groups = new ArrayList();
        for (String groupName : new OneUseIterable(root.getFieldNames())) {
            InteractionNetworkGroup targetGroup = null;
            for (InteractionNetworkGroup group : allGroups) {
                if (!group.getName().equalsIgnoreCase(groupName) && !group.getCode().equalsIgnoreCase(groupName)) continue;
                targetGroup = group;
                break;
            }
            if (targetGroup == null) continue;
            ArrayList<Network<InteractionNetwork>> networks = new ArrayList<Network<InteractionNetwork>>();
            for (JsonNode node : new OneUseIterable(root.get(groupName).getElements())) {
                String networkName = node.getTextValue();
                for (InteractionNetwork network : targetGroup.getInteractionNetworks()) {
                    if (!network.getName().equalsIgnoreCase(networkName)) continue;
                    networks.add(new InteractionNetworkImpl(network, 0.0));
                }
            }
            if (networks.size() <= 0) continue;
            groups.add(new InteractionNetworkGroupImpl(targetGroup, networks));
        }
        return groups;
    }

    private List<String> parseGenes(DataSet data, JsonNode root) {
        ArrayList<String> genes = new ArrayList<String>();
        for (JsonNode node : new OneUseIterable(root.getElements())) {
            genes.add(node.getTextValue());
        }
        return genes;
    }
}

