/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.report;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractXMLReader
implements XMLReader {
    protected static final String TYPE_STRING = "xsd:string";
    protected static final String TYPE_NUMBER = "xsd:number";
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private Attributes emptyAttributes = new AttributesImpl();

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException(name);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException(name);
    }

    public void serialize(OutputStream stream) throws SAXException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(2));
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StreamResult result = new StreamResult(new OutputStreamWriter(stream, "utf-8"));
            SAXSource source = new SAXSource(this, new InputSource());
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e);
        }
        catch (TransformerException e) {
            throw new SAXException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String name, Attributes attributes) throws SAXException {
        this.contentHandler.startElement("", name, name, attributes);
    }

    public void startElement(String name) throws SAXException {
        this.contentHandler.startElement("", name, name, this.emptyAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleElement(String name, String contents) throws SAXException {
        this.contentHandler.startElement("", name, name, this.emptyAttributes);
        try {
            if (contents != null && contents.length() > 0) {
                this.contentHandler.characters(contents.toCharArray(), 0, contents.length());
            }
        }
        finally {
            this.contentHandler.endElement("", name, name);
        }
    }

    public void simpleElement(String name, Attributes attributes) throws SAXException {
        this.contentHandler.startElement("", name, name, attributes);
        this.contentHandler.endElement("", name, name);
    }

    public void endElement(String name) throws SAXException {
        this.contentHandler.endElement("", name, name);
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }
}

