/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.report;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.genemania.domain.Attribute;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.Gene;
import org.genemania.domain.Interaction;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.NetworkMetadata;
import org.genemania.domain.Node;
import org.genemania.domain.Tag;
import org.genemania.plugin.Metadata;
import org.genemania.plugin.Strings;
import org.genemania.plugin.controllers.IGeneProvider;
import org.genemania.plugin.model.AnnotationEntry;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.model.impl.QueryAttributeGroupImpl;
import org.genemania.plugin.model.impl.QueryAttributeNetworkImpl;
import org.genemania.plugin.report.ManiaReport;
import org.genemania.plugin.report.ReportExporter;
import org.genemania.type.CombiningMethod;

public class TextReportExporter
implements ReportExporter {
    private final IGeneProvider geneProvider;
    private Group<?, ?> attributeGroup;
    private Map<Long, Gene> geneCache;

    public TextReportExporter(IGeneProvider geneProvider) {
        this.geneProvider = geneProvider;
        List<Network<AttributeGroup>> networks = Collections.emptyList();
        this.attributeGroup = new QueryAttributeGroupImpl((Collection<Network<AttributeGroup>>)networks);
        this.geneCache = new HashMap<Long, Gene>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(ManiaReport report, OutputStream stream) {
        PrintWriter writer = new PrintWriter(stream);
        try {
            writer.print("GeneMANIA Results\n");
            this.exportVersion(report, writer);
            this.exportGenes(report, writer);
            this.exportNetworks(report, writer);
            this.exportInteractions(report, writer);
            this.exportEnrichment(report, writer);
            this.exportEnrichmentSummary(report, writer);
            this.exportParameters(report, writer);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportEnrichment(ManiaReport report, PrintWriter writer) {
        SearchResult options = report.getViewState().getSearchResult();
        writer.println("Gene\tGO ids");
        ArrayList<ManiaReport.GeneEntry> genes = new ArrayList<ManiaReport.GeneEntry>(report.getGenes());
        Collections.sort(genes, new Comparator<ManiaReport.GeneEntry>(){

            @Override
            public int compare(ManiaReport.GeneEntry o1, ManiaReport.GeneEntry o2) {
                return o1.getGene().getSymbol().compareToIgnoreCase(o2.getGene().getSymbol());
            }
        });
        for (ManiaReport.GeneEntry entry : genes) {
            try {
                Gene gene = entry.getGene();
                gene = this.findGene(gene.getNode(), options);
                writer.print(this.getGeneLabel(gene));
                Collection<AnnotationEntry> annotations = options.getAnnotations(gene.getNode().getId());
                if (annotations == null) continue;
                ArrayList<AnnotationEntry> sortedAnnotations = new ArrayList<AnnotationEntry>(annotations);
                Collections.sort(sortedAnnotations, new Comparator<AnnotationEntry>(){

                    @Override
                    public int compare(AnnotationEntry o1, AnnotationEntry o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                for (AnnotationEntry annotation : sortedAnnotations) {
                    writer.print("\t");
                    writer.print(annotation.getName());
                }
            }
            finally {
                writer.println();
            }
        }
        writer.println();
    }

    private void exportEnrichmentSummary(ManiaReport report, PrintWriter writer) {
        SearchResult options = report.getViewState().getSearchResult();
        List<AnnotationEntry> enrichment = options.getEnrichmentSummary();
        writer.println("GO id\tDescription\tq-value\tOccurrences in Sample\tOccurrences in Genome");
        for (AnnotationEntry annotation : enrichment) {
            writer.print(annotation.getName());
            writer.print("\t");
            writer.print(annotation.getDescription());
            writer.print("\t");
            writer.print(annotation.getQValue());
            writer.print("\t");
            writer.print(annotation.getSampleOccurrences());
            writer.print("\t");
            writer.print(annotation.getTotalOccurrences());
            writer.println();
        }
        writer.println();
    }

    private void exportInteractions(ManiaReport report, PrintWriter writer) {
        AttributeGroup group;
        final SearchResult options = report.getViewState().getSearchResult();
        writer.println("Gene 1\tGene 2\tWeight\tType\tSource");
        ArrayList<InteractionEntry> entries = new ArrayList<InteractionEntry>();
        for (Map.Entry<Long, Collection<Attribute>> entry : options.getAttributesByNodeId().entrySet()) {
            Gene gene = options.getGene(entry.getKey());
            for (Attribute attribute : entry.getValue()) {
                group = options.getAttributeGroup(attribute.getId());
                entries.add(new InteractionEntry(attribute.getName(), gene.getSymbol(), group.getName(), 0.0));
            }
        }
        Collections.sort(entries, new Comparator<InteractionEntry>(){

            @Override
            public int compare(InteractionEntry entry1, InteractionEntry entry2) {
                int result = String.CASE_INSENSITIVE_ORDER.compare(entry1.getType(), entry2.getType());
                if (result != 0) {
                    return result;
                }
                result = String.CASE_INSENSITIVE_ORDER.compare(entry1.getFrom(), entry2.getFrom());
                if (result != 0) {
                    return result;
                }
                return String.CASE_INSENSITIVE_ORDER.compare(entry1.getTo(), entry2.getTo());
            }
        });
        for (InteractionEntry interactionEntry : entries) {
            writer.print(interactionEntry.getFrom());
            writer.print("\t");
            writer.print(interactionEntry.getTo());
            writer.print("\t");
            writer.print(interactionEntry.getWeight() * 100.0);
            writer.print("\t");
            writer.print(interactionEntry.getType());
            writer.print("\t");
            writer.println();
        }
        Map<InteractionNetwork, Double> networkWeights = options.getNetworkWeights();
        Map<Long, Double> map = this.remapWeights(networkWeights);
        ArrayList<InteractionNetwork> keys = new ArrayList<InteractionNetwork>(networkWeights.keySet());
        Collections.sort(keys, new Comparator<InteractionNetwork>(){

            @Override
            public int compare(InteractionNetwork o1, InteractionNetwork o2) {
                InteractionNetworkGroup group1 = options.getInteractionNetworkGroup(o1.getId());
                InteractionNetworkGroup group2 = options.getInteractionNetworkGroup(o2.getId());
                if (group1.getId() == group2.getId()) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
                return group1.getName().compareToIgnoreCase(group2.getName());
            }
        });
        for (InteractionNetwork network : keys) {
            group = options.getInteractionNetworkGroup(network.getId());
            ArrayList interactions = new ArrayList(network.getInteractions());
            Collections.sort(interactions, new Comparator<Interaction>(){

                @Override
                public int compare(Interaction o1, Interaction o2) {
                    Gene gene1 = TextReportExporter.this.findGene(o1.getFromNode(), options);
                    Gene gene2 = TextReportExporter.this.findGene(o2.getFromNode(), options);
                    int ordering = gene1.getSymbol().compareToIgnoreCase(gene2.getSymbol());
                    if (ordering != 0) {
                        return ordering;
                    }
                    gene1 = TextReportExporter.this.findGene(o1.getToNode(), options);
                    gene2 = TextReportExporter.this.findGene(o2.getToNode(), options);
                    return gene1.getSymbol().compareToIgnoreCase(gene2.getSymbol());
                }
            });
            for (Interaction interaction : interactions) {
                writer.print(this.findGene(interaction.getFromNode(), options).getSymbol());
                writer.print("\t");
                writer.print(this.findGene(interaction.getToNode(), options).getSymbol());
                writer.print("\t");
                writer.print((double)interaction.getWeight() * map.get(network.getId()) * 100.0);
                writer.print("\t");
                writer.print(group.getName());
                writer.print("\t");
                writer.print(network.getName());
                writer.println();
            }
        }
        writer.println();
    }

    private Map<Long, Double> remapWeights(Map<InteractionNetwork, Double> weights) {
        HashMap<Long, Double> result = new HashMap<Long, Double>();
        for (Map.Entry<InteractionNetwork, Double> entry : weights.entrySet()) {
            result.put(entry.getKey().getId(), entry.getValue());
        }
        return result;
    }

    private Gene findGene(Node node, SearchResult options) {
        long nodeId = node.getId();
        if (options.isQueryNode(nodeId)) {
            return options.getGene(node.getId());
        }
        Gene gene = this.geneCache.get(node.getId());
        if (gene == null) {
            gene = this.geneProvider.getGene(node);
            this.geneCache.put(node.getId(), gene);
        }
        return gene;
    }

    private void exportVersion(ManiaReport report, PrintWriter writer) {
        Metadata metadata = new Metadata();
        String version = metadata.getCytoscapeVersion();
        String buildId = metadata.getBuildId();
        writer.print("Plugin Version\t");
        writer.print(version == null ? "development" : version);
        if (buildId != null) {
            writer.print(" (");
            writer.print(buildId);
            writer.print(")");
        }
        writer.print("\n");
        writer.print("Data Version\t");
        writer.print(report.getDataVersion());
        writer.print("\n");
        writer.print("Report Generated\t");
        writer.print(new Date());
        writer.print("\n\n");
    }

    private void exportParameters(ManiaReport report, PrintWriter writer) {
        writer.print("Query Parameters\n");
        final ViewState viewState = report.getViewState();
        SearchResult options = viewState.getSearchResult();
        writer.print("Organism\t");
        writer.print(options.getOrganism().getName());
        writer.print("\n");
        writer.print("Network Weighting\t");
        writer.print(this.formatCombiningMethod(options.getCombiningMethod()));
        writer.print("\n");
        writer.print("Related Genes Limit\t");
        writer.print(options.getGeneSearchLimit());
        writer.print("\n");
        writer.print("Related Attributes Limit\t");
        writer.print(options.getAttributeSearchLimit());
        writer.print("\n");
        writer.print("Input Genes");
        for (Gene gene : options.getQueryGenes().values()) {
            writer.print("\t");
            writer.print(gene.getSymbol());
        }
        writer.print("\n");
        writer.print("Networks\n");
        ArrayList networks = new ArrayList(report.getNetworks());
        this.filterAttributes(networks, viewState);
        Collections.sort(networks, new Comparator<Network<?>>(){

            @Override
            public int compare(Network<?> network1, Network<?> network2) {
                Group group1 = TextReportExporter.this.getGroup(network1, viewState);
                Group group2 = TextReportExporter.this.getGroup(network2, viewState);
                int result = String.CASE_INSENSITIVE_ORDER.compare(group1.getName(), group2.getName());
                if (result != 0) {
                    return result;
                }
                return String.CASE_INSENSITIVE_ORDER.compare(network1.getName(), network2.getName());
            }
        });
        for (Network network : networks) {
            writer.print("\t");
            writer.print(network.getName());
            writer.print("\t");
            Group<?, ?> group = this.getGroup(network, viewState);
            writer.print(group.getName());
            writer.print("\n");
        }
        writer.print("\n");
    }

    private Group<?, ?> getGroup(Network<?> entry, ViewState viewState) {
        Group<?, ?> group = viewState.getGroup(entry);
        if (group == null) {
            AttributeGroup adapted = entry.adapt(AttributeGroup.class);
            if (adapted == null) {
                return null;
            }
            return this.attributeGroup;
        }
        return group;
    }

    private void filterAttributes(List<Network<?>> networks, ViewState viewState) {
        HashMap<String, QueryAttributeNetworkImpl> newNetworks = new HashMap<String, QueryAttributeNetworkImpl>();
        for (Network<?> network : networks) {
            AttributeGroup model;
            Group<?, ?> group = viewState.getGroup(network);
            Group<AttributeGroup, Attribute> adapted = group.adapt(AttributeGroup.class, Attribute.class);
            if (adapted == null || newNetworks.containsKey((model = adapted.getModel()).getName())) continue;
            newNetworks.put(model.getName(), new QueryAttributeNetworkImpl(model, 0.0));
        }
        for (Network network : newNetworks.values()) {
            networks.add(network);
        }
    }

    private String formatCombiningMethod(CombiningMethod combiningMethod) {
        switch (combiningMethod) {
            case AUTOMATIC: {
                return Strings.automatic;
            }
            case AVERAGE: {
                return Strings.average;
            }
            case AVERAGE_CATEGORY: {
                return Strings.average_category;
            }
            case BP: {
                return Strings.bp;
            }
            case MF: {
                return Strings.mf;
            }
            case CC: {
                return Strings.cc;
            }
        }
        return Strings.default_combining_method;
    }

    private void exportNetworks(ManiaReport report, PrintWriter writer) {
        Group<?, ?> lastGroup = null;
        writer.print("Network Group");
        writer.print("\t");
        writer.print("Network");
        writer.print("\t");
        writer.print("Weight");
        writer.print("\t");
        writer.print("Title");
        writer.print("\t");
        writer.print("Authors");
        writer.print("\t");
        writer.print("Year");
        writer.print("\t");
        writer.print("Publication");
        writer.print("\t");
        writer.print("PMID");
        writer.print("\t");
        writer.print("URL");
        writer.print("\t");
        writer.print("Processing Method");
        writer.print("\t");
        writer.print("Interactions");
        writer.print("\t");
        writer.print("Source");
        writer.print("\t");
        writer.print("Source URL");
        writer.print("\t");
        writer.print("Tags");
        writer.print("\n");
        ViewState viewState = report.getViewState();
        for (Network<?> entry : report.getNetworks()) {
            InteractionNetwork network;
            Group<?, ?> group = viewState.getGroup(entry);
            if (lastGroup == null || group != lastGroup) {
                writer.print(group.getName());
                writer.print("\t\t");
                writer.print(String.format("%.2f", group.getWeight() * 100.0));
                writer.print("\n");
            }
            if ((network = entry.adapt(InteractionNetwork.class)) != null) {
                NetworkMetadata metadata = network.getMetadata();
                writer.print("\t");
                writer.print(network.getName());
                writer.print("\t");
                writer.print(String.format("%.2f", entry.getWeight() * 100.0));
                writer.print("\t");
                writer.print(metadata.getTitle());
                writer.print("\t");
                writer.print(metadata.getAuthors());
                writer.print("\t");
                writer.print(metadata.getYearPublished());
                writer.print("\t");
                writer.print(metadata.getPublicationName());
                writer.print("\t");
                writer.print(metadata.getPubmedId());
                writer.print("\t");
                writer.print(metadata.getUrl());
                writer.print("\t");
                writer.print(metadata.getProcessingDescription());
                writer.print("\t");
                writer.print(metadata.getInteractionCount());
                writer.print("\t");
                writer.print(metadata.getSource());
                writer.print("\t");
                writer.print(metadata.getSourceUrl());
                writer.print("\t");
                boolean first = true;
                for (Tag tag : network.getTags()) {
                    if (!first) {
                        writer.print(",");
                    }
                    writer.print(tag.getName());
                    first = false;
                }
            }
            Group<AttributeGroup, Attribute> attributeGroup = group.adapt(AttributeGroup.class, Attribute.class);
            Attribute network2 = entry.adapt(Attribute.class);
            if (attributeGroup != null && network2 != null) {
                AttributeGroup groupModel = attributeGroup.getModel();
                writer.print("\t");
                writer.print(network2.getName());
                writer.print("\t");
                writer.print(String.format("%.2f", entry.getWeight() * 100.0));
                writer.print("\t");
                writer.print(network2.getDescription());
                writer.print("\t");
                writer.print("\t");
                writer.print("\t");
                writer.print(groupModel.getPublicationName());
                writer.print("\t");
                writer.print("\t");
                writer.print(groupModel.getPublicationUrl());
                writer.print("\t");
                writer.print("\t");
                writer.print("\t");
                writer.print(groupModel.getLinkoutLabel());
                writer.print("\t");
                writer.print(groupModel.getLinkoutUrl());
                writer.print("\t");
            }
            writer.print("\n");
            lastGroup = group;
        }
        writer.print("\n");
    }

    private void exportGenes(ManiaReport report, PrintWriter writer) {
        SearchResult options = report.getViewState().getSearchResult();
        writer.print("Gene\tScore\tDescription\n");
        for (ManiaReport.GeneEntry entry : report.getGenes()) {
            Gene gene = this.findGene(entry.getGene().getNode(), options);
            writer.print(this.getGeneLabel(gene));
            writer.print("\t");
            double score = entry.getScore();
            if (score != Double.MAX_VALUE) {
                writer.print(String.format("%.2f", score));
            }
            writer.print("\t");
            writer.print(gene.getNode().getGeneData().getDescription());
            writer.print("\n");
        }
        writer.print("\n");
    }

    protected String getGeneLabel(Gene gene) {
        return gene.getSymbol();
    }

    private static class InteractionEntry {
        String from;
        String to;
        String type;
        Double weight;

        public InteractionEntry(String from, String to, String type, Double weight) {
            this.from = from;
            this.to = to;
            this.type = type;
            this.weight = weight;
        }

        public Double getWeight() {
            return this.weight;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public String getType() {
            return this.type;
        }
    }
}

