/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.selection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.genemania.domain.Attribute;
import org.genemania.domain.Gene;
import org.genemania.domain.Node;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.proxies.EdgeProxy;
import org.genemania.plugin.proxies.NetworkProxy;
import org.genemania.plugin.proxies.NodeProxy;
import org.genemania.plugin.selection.SelectionEvent;
import org.genemania.plugin.selection.SelectionListener;
import org.genemania.plugin.view.FunctionInfoPanel;
import org.genemania.plugin.view.GeneInfoPanel;
import org.genemania.plugin.view.NetworkChangeListener;
import org.genemania.plugin.view.NetworkGroupDetailPanel;
import org.genemania.plugin.view.components.BaseInfoPanel;

public class NetworkSelectionManager<NETWORK, NODE, EDGE> {
    private final PropertyChangeListener changeListener;
    private final Map<Object, ViewState> networkOptions;
    private final PropertyChangeListener destroyedListener;
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;
    private final GeneMania<NETWORK, NODE, EDGE> plugin;
    private String selectedNetworkId;
    private boolean selectionListenerEnabled;

    public NetworkSelectionManager(GeneMania<NETWORK, NODE, EDGE> plugin, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils) {
        this.plugin = plugin;
        this.cytoscapeUtils = cytoscapeUtils;
        this.changeListener = new NetworkSelectionChangeListener();
        this.destroyedListener = new NetworkDestroyedListener();
        this.networkOptions = new HashMap<Object, ViewState>();
        this.selectionListenerEnabled = true;
    }

    public String getSelectedNetworkId() {
        return this.selectedNetworkId;
    }

    public int getTotalNetworks() {
        return this.networkOptions.size();
    }

    public void addNetworkConfiguration(NETWORK network, ViewState config) {
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.cytoscapeUtils.getNetworkProxy(network);
        this.networkOptions.put(proxy.getIdentifier(), config);
    }

    public ViewState getNetworkConfiguration(NETWORK network) {
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.cytoscapeUtils.getNetworkProxy(network);
        return this.networkOptions.get(proxy.getIdentifier());
    }

    public boolean isGeneManiaNetwork(NETWORK network) {
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.cytoscapeUtils.getNetworkProxy(network);
        return this.networkOptions.get(proxy.getIdentifier()) != null;
    }

    public NetworkChangeListener<NETWORK, NODE, EDGE> createChangeListener(Group<?, ?> group) {
        return new NetworkChangeListener<NETWORK, NODE, EDGE>(group, this.networkOptions, this.cytoscapeUtils);
    }

    public PropertyChangeListener getNetworkChangeListener() {
        return this.changeListener;
    }

    public PropertyChangeListener getNetworkDestroyedListener() {
        return this.destroyedListener;
    }

    public void setSelectionListenerEnabled(boolean enabled) {
        this.selectionListenerEnabled = enabled;
    }

    public boolean isSelectionListenerEnabled() {
        return this.selectionListenerEnabled;
    }

    public SelectionListener<Gene> createGeneListSelectionListener(GeneInfoPanel genePanel, final ViewState options) {
        return new SelectionListener<Gene>(){

            @Override
            public void selectionChanged(SelectionEvent<Gene> event) {
                if (!NetworkSelectionManager.this.selectionListenerEnabled) {
                    return;
                }
                boolean listenerState = NetworkSelectionManager.this.selectionListenerEnabled;
                NetworkSelectionManager.this.selectionListenerEnabled = false;
                Object network = NetworkSelectionManager.this.cytoscapeUtils.getCurrentNetwork();
                NetworkProxy proxy = NetworkSelectionManager.this.cytoscapeUtils.getNetworkProxy(network);
                for (Gene gene : event.items) {
                    Node node = gene.getNode();
                    Object cyNode = NetworkSelectionManager.this.cytoscapeUtils.getNode(network, node, null);
                    NodeProxy nodeProxy = NetworkSelectionManager.this.cytoscapeUtils.getNodeProxy(cyNode, network);
                    options.setGeneHighlighted(nodeProxy.getIdentifier(), event.selected);
                    proxy.setSelectedNode(cyNode, event.selected);
                }
                NetworkSelectionManager.this.selectionListenerEnabled = listenerState;
                NetworkSelectionManager.this.cytoscapeUtils.repaint();
            }
        };
    }

    public boolean checkSelectionState(EDGE referenceEdge, Set<EDGE> selectedEdges, NETWORK network) {
        EdgeProxy<EDGE, NODE> referenceEdgeProxy = this.cytoscapeUtils.getEdgeProxy(referenceEdge, network);
        String target = referenceEdgeProxy.getAttribute("data type", String.class);
        if (target == null) {
            return false;
        }
        for (EDGE edge : selectedEdges) {
            EdgeProxy<EDGE, NODE> edgeProxy = this.cytoscapeUtils.getEdgeProxy(edge, network);
            String id = edgeProxy.getAttribute("data type", String.class);
            if (id == null || id != target) continue;
            return false;
        }
        return true;
    }

    public SelectionListener<Group<?, ?>> createNetworkListSelectionListener(BaseInfoPanel<Group<?, ?>, NetworkGroupDetailPanel<NETWORK, NODE, EDGE>> panel, ViewState options) {
        return new SelectionListener<Group<?, ?>>(){

            @Override
            public void selectionChanged(SelectionEvent<Group<?, ?>> event) {
                Group<?, ?> group;
                if (!NetworkSelectionManager.this.selectionListenerEnabled) {
                    return;
                }
                Object cyNetwork = NetworkSelectionManager.this.cytoscapeUtils.getCurrentNetwork();
                NetworkProxy networkProxy = NetworkSelectionManager.this.cytoscapeUtils.getNetworkProxy(cyNetwork);
                ViewState options = (ViewState)NetworkSelectionManager.this.networkOptions.get(networkProxy.getIdentifier());
                if (options == null) {
                    return;
                }
                HashSet<Object> enabledEdges = new HashSet<Object>();
                HashSet<Object> disabledEdges = new HashSet<Object>();
                HashMap<String, Boolean> selectionChanges = new HashMap<String, Boolean>();
                for (Group group2 : event.items) {
                    selectionChanges.put(group2.getName(), event.selected);
                    options.setGroupHighlighted(group2, event.selected);
                }
                for (Object edge : networkProxy.getEdges()) {
                    EdgeProxy edgeProxy = NetworkSelectionManager.this.cytoscapeUtils.getEdgeProxy(edge, cyNetwork);
                    String name = edgeProxy.getAttribute("data type", String.class);
                    Boolean selectionState = (Boolean)selectionChanges.get(name);
                    if (selectionState == null) {
                        edgeProxy.setAttribute("highlight", 0);
                        continue;
                    }
                    if (selectionState.booleanValue()) {
                        enabledEdges.add(edge);
                    } else {
                        disabledEdges.add(edge);
                    }
                    group = options.getGroup(name);
                    boolean highlighted = selectionState != false || options.getEnabled(group);
                    edgeProxy.setAttribute("highlight", highlighted ? 1 : 0);
                }
                boolean listenerState = NetworkSelectionManager.this.selectionListenerEnabled;
                NetworkSelectionManager.this.selectionListenerEnabled = false;
                if (enabledEdges.size() > 0) {
                    networkProxy.setSelectedEdges(enabledEdges, true);
                }
                if (disabledEdges.size() > 0) {
                    networkProxy.setSelectedEdges(disabledEdges, false);
                }
                NetworkSelectionManager.this.selectionListenerEnabled = listenerState;
                if (networkProxy.getSelectedEdges().size() == 0) {
                    for (Object edge : networkProxy.getEdges()) {
                        EdgeProxy edgeProxy = NetworkSelectionManager.this.cytoscapeUtils.getEdgeProxy(edge, cyNetwork);
                        String name = edgeProxy.getAttribute("data type", String.class);
                        group = options.getGroup(name);
                        if (options.getEnabled(group)) {
                            edgeProxy.setAttribute("highlight", 1);
                            continue;
                        }
                        edgeProxy.setAttribute("highlight", 0);
                    }
                }
                NetworkSelectionManager.this.cytoscapeUtils.updateVisualStyles(cyNetwork);
                NetworkSelectionManager.this.cytoscapeUtils.repaint();
            }
        };
    }

    public SelectionListener<Network<?>> createNetworkSelectionListener() {
        return new SelectionListener<Network<?>>(){

            @Override
            public void selectionChanged(SelectionEvent<Network<?>> event) {
                Boolean selected;
                if (!NetworkSelectionManager.this.selectionListenerEnabled) {
                    return;
                }
                Object cyNetwork = NetworkSelectionManager.this.cytoscapeUtils.getCurrentNetwork();
                NetworkProxy networkProxy = NetworkSelectionManager.this.cytoscapeUtils.getNetworkProxy(cyNetwork);
                ViewState options = (ViewState)NetworkSelectionManager.this.networkOptions.get(networkProxy.getIdentifier());
                if (options == null) {
                    return;
                }
                HashMap<String, Boolean> edgeSelectionChanges = new HashMap<String, Boolean>();
                HashMap<String, Boolean> nodeSelectionChanges = new HashMap<String, Boolean>();
                for (Network network : event.items) {
                    Attribute attribute = network.adapt(Attribute.class);
                    if (attribute != null) {
                        nodeSelectionChanges.put(network.getName(), event.selected);
                        options.setGeneHighlighted(attribute.getName(), true);
                        continue;
                    }
                    edgeSelectionChanges.put(network.getName(), event.selected);
                    options.setNetworkHighlighted(network, event.selected);
                }
                HashSet enabledEdges = new HashSet();
                HashSet disabledEdges = new HashSet();
                for (Object edge : networkProxy.getEdges()) {
                    String attributeName;
                    EdgeProxy edgeProxy = NetworkSelectionManager.this.cytoscapeUtils.getEdgeProxy(edge, cyNetwork);
                    List names = edgeProxy.getAttribute("networks", List.class);
                    if (names == null) continue;
                    boolean selectionState = false;
                    for (String name : names) {
                        Boolean selected2 = (Boolean)edgeSelectionChanges.get(name);
                        if (!(selectionState = selectionState || selected2 != null && selected2 != false)) continue;
                        break;
                    }
                    if ((attributeName = edgeProxy.getAttribute("attribute name", String.class)) != null) {
                        selected = (Boolean)nodeSelectionChanges.get(attributeName);
                        boolean bl = selectionState = selectionState || selected != null && selected != false;
                    }
                    if (selectionState) {
                        enabledEdges.add(edge);
                    } else {
                        disabledEdges.add(edge);
                    }
                    edgeProxy.setAttribute("highlight", selectionState ? 1 : 0);
                }
                HashSet enabledNodes = new HashSet();
                HashSet disabledNodes = new HashSet();
                for (Object node : networkProxy.getNodes()) {
                    NodeProxy nodeProxy = NetworkSelectionManager.this.cytoscapeUtils.getNodeProxy(node, cyNetwork);
                    String name = nodeProxy.getAttribute("gene name", String.class);
                    if (name == null) continue;
                    selected = (Boolean)nodeSelectionChanges.get(name);
                    if (selected != null && selected.booleanValue()) {
                        enabledNodes.add(node);
                        continue;
                    }
                    disabledNodes.add(node);
                }
                boolean listenerState = NetworkSelectionManager.this.selectionListenerEnabled;
                NetworkSelectionManager.this.selectionListenerEnabled = false;
                if (enabledEdges.size() > 0) {
                    networkProxy.setSelectedEdges(enabledEdges, true);
                }
                if (disabledEdges.size() > 0) {
                    networkProxy.setSelectedEdges(disabledEdges, false);
                }
                if (enabledNodes.size() > 0) {
                    networkProxy.setSelectedNodes(enabledNodes, true);
                }
                if (disabledNodes.size() > 0) {
                    networkProxy.setSelectedNodes(disabledNodes, false);
                }
                NetworkSelectionManager.this.selectionListenerEnabled = listenerState;
                if (networkProxy.getSelectedEdges().size() == 0) {
                    for (Object edge : networkProxy.getEdges()) {
                        String name;
                        EdgeProxy edgeProxy = NetworkSelectionManager.this.cytoscapeUtils.getEdgeProxy(edge, cyNetwork);
                        name = edgeProxy.getAttribute("data type", String.class);
                        Group<?, ?> group = options.getGroup(name);
                        if (options.getEnabled(group)) {
                            edgeProxy.setAttribute("highlight", 1);
                            continue;
                        }
                        edgeProxy.setAttribute("highlight", 0);
                    }
                }
                NetworkSelectionManager.this.cytoscapeUtils.updateVisualStyles(cyNetwork);
                NetworkSelectionManager.this.cytoscapeUtils.repaint();
            }
        };
    }

    public SelectionListener<Gene> createFunctionListSelectionListener(FunctionInfoPanel functionPanel, SearchResult options) {
        return new SelectionListener<Gene>(){

            @Override
            public void selectionChanged(SelectionEvent<Gene> event) {
                if (!NetworkSelectionManager.this.selectionListenerEnabled) {
                    return;
                }
                Object cyNetwork = NetworkSelectionManager.this.cytoscapeUtils.getCurrentNetwork();
                NetworkProxy networkProxy = NetworkSelectionManager.this.cytoscapeUtils.getNetworkProxy(cyNetwork);
                ViewState options = (ViewState)NetworkSelectionManager.this.networkOptions.get(networkProxy.getIdentifier());
                if (options == null) {
                    return;
                }
                HashSet<Long> selectedNodes = new HashSet<Long>();
                for (Gene gene : event.items) {
                    selectedNodes.add(gene.getNode().getId());
                }
                boolean listenerState = NetworkSelectionManager.this.selectionListenerEnabled;
                NetworkSelectionManager.this.selectionListenerEnabled = false;
                networkProxy.unselectAllEdges();
                networkProxy.unselectAllNodes();
                for (Object node : networkProxy.getNodes()) {
                    NodeProxy nodeProxy = NetworkSelectionManager.this.cytoscapeUtils.getNodeProxy(node, cyNetwork);
                    Long nodeId = options.getNodeId(nodeProxy.getIdentifier());
                    if (!selectedNodes.contains(nodeId)) continue;
                    networkProxy.setSelectedNode(node, true);
                }
                NetworkSelectionManager.this.selectionListenerEnabled = listenerState;
                NetworkSelectionManager.this.cytoscapeUtils.repaint();
            }
        };
    }

    private class NetworkDestroyedListener
    implements PropertyChangeListener {
        private NetworkDestroyedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            NetworkDestroyedListener networkDestroyedListener = this;
            synchronized (networkDestroyedListener) {
                String networkId = (String)event.getNewValue();
                if (networkId == null) {
                    return;
                }
                NetworkSelectionManager.this.networkOptions.remove(networkId);
                if (NetworkSelectionManager.this.networkOptions.size() == 0) {
                    NetworkSelectionManager.this.plugin.hideResults();
                }
            }
        }
    }

    private class NetworkSelectionChangeListener
    implements PropertyChangeListener {
        private NetworkSelectionChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            NetworkSelectionChangeListener networkSelectionChangeListener = this;
            synchronized (networkSelectionChangeListener) {
                String networkId = (String)event.getNewValue();
                if (networkId == null && NetworkSelectionManager.this.selectedNetworkId == null) {
                    return;
                }
                NetworkSelectionManager.this.selectedNetworkId = networkId;
                if (networkId == null) {
                    return;
                }
                ViewState options = (ViewState)NetworkSelectionManager.this.networkOptions.get(networkId);
                if (options == null) {
                    NetworkSelectionManager.this.plugin.hideResults();
                    return;
                }
                NetworkSelectionManager.this.plugin.applyOptions(options);
                NetworkSelectionManager.this.plugin.showResults();
            }
        }
    }
}

