/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.task;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.UIManager;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.task.GeneManiaTask;
import org.genemania.plugin.view.TaskDialog;
import org.genemania.plugin.view.util.UiUtils;

public class TaskDispatcher {
    private final UiUtils uiUtils;
    private final Object mutex = new Object();
    private final Object executionMutex = new Object();
    private Thread taskThread;
    private TaskDialog taskDialog;

    public TaskDispatcher(UiUtils uiUtils) {
        this.uiUtils = uiUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(GeneManiaTask task, Window owner, boolean modal, boolean cancelable) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.taskDialog != null) {
                throw new RuntimeException();
            }
            if (owner instanceof Frame) {
                this.taskDialog = new TaskDialog((Frame)owner, task.getTitle(), modal, cancelable, this.uiUtils);
            } else if (owner instanceof Dialog) {
                this.taskDialog = new TaskDialog((Dialog)owner, task.getTitle(), modal, cancelable, this.uiUtils);
            } else {
                throw new RuntimeException();
            }
            this.taskDialog.setMinimumSize(new Dimension(500, 220));
            this.taskDialog.setLocationByPlatform(true);
            this.taskDialog.setStatusIcon(UIManager.getIcon("OptionPane.informationIcon"));
            this.taskDialog.pack();
        }
        Object executionMutex = new Object();
        this.taskThread = new Thread(this.createTaskHandler(task));
        this.taskThread.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Object object2 = executionMutex;
        synchronized (object2) {
            if (this.taskDialog == null) {
                return;
            }
            if (!this.taskThread.isAlive() && task.getLastError() != null) {
                return;
            }
            this.taskDialog.setVisible(true);
        }
    }

    protected Runnable createTaskHandler(GeneManiaTask task) {
        return new TaskHandler(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinTask() throws ApplicationException {
        Object object = this.executionMutex;
        synchronized (object) {
            if (this.taskThread == null) {
                return;
            }
        }
        try {
            this.taskThread.join();
        }
        catch (InterruptedException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public TaskDialog getTaskDialog() {
        return this.taskDialog;
    }

    public class TaskHandler
    implements Runnable {
        private GeneManiaTask task;

        public TaskHandler(GeneManiaTask task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.task.setProgressReporter(TaskDispatcher.this.taskDialog);
            this.task.run();
            Throwable lastError = this.task.getLastError();
            try {
                if (lastError != null) {
                    LogUtils.log(this.getClass(), lastError);
                    TaskDispatcher.this.taskDialog.setStatusIcon(UIManager.getIcon("OptionPane.errorIcon"));
                    TaskDispatcher.this.taskDialog.setStatus(Strings.taskDialog_error);
                    if (lastError instanceof OutOfMemoryError) {
                        TaskDispatcher.this.taskDialog.setDescription(Strings.taskDialogOutOfMemory_error);
                    } else {
                        TaskDispatcher.this.taskDialog.setDescription(lastError.getMessage());
                    }
                    TaskDispatcher.this.taskDialog.enableCloseButton(true);
                } else {
                    TaskDispatcher.this.taskDialog.setVisible(false);
                }
            }
            finally {
                Object object = TaskDispatcher.this.executionMutex;
                synchronized (object) {
                    TaskDispatcher.this.taskDialog = null;
                    TaskDispatcher.this.taskThread = null;
                }
            }
        }
    }
}

