/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.genemania.domain.Organism;

public class OrganismValidator {
    private final Set<String> existingNames = new HashSet<String>();
    private final Set<String> existingAliases = new HashSet<String>();
    private final Set<Long> existingTaxIds = new HashSet<Long>();
    private Organism currentOrganism;

    public void setOrganisms(List<Organism> organisms) {
        this.existingNames.clear();
        this.existingAliases.clear();
        this.existingTaxIds.clear();
        for (Organism organism : organisms) {
            this.existingNames.add(organism.getName());
            this.existingAliases.add(organism.getAlias());
            this.existingTaxIds.add(organism.getTaxonomyId());
        }
    }

    public void setCurrentOrganism(Organism organism) {
        this.currentOrganism = organism;
    }

    public boolean isValidName(String name) {
        return this.isValidId(name, this.existingNames) || name != null && this.currentOrganism != null && name.equals(this.currentOrganism.getName());
    }

    public boolean isValidAlias(String alias) {
        return this.isValidId(alias, this.existingAliases) || alias != null && this.currentOrganism != null && alias.equals(this.currentOrganism.getAlias());
    }

    public boolean isValidTaxonomyId(String text) {
        if (text == null || text.isEmpty()) {
            return true;
        }
        try {
            long taxId = Long.parseLong(text);
            return !this.existingTaxIds.contains(taxId) || this.currentOrganism != null && taxId == this.currentOrganism.getTaxonomyId();
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isValidId(String element, Set<String> set) {
        if (element == null || element.isEmpty()) {
            return false;
        }
        return !set.contains(element);
    }
}

