/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.genemania.domain.Gene;
import org.genemania.plugin.Strings;
import org.genemania.plugin.completion.DynamicTableModel;
import org.genemania.plugin.model.AnnotationEntry;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.selection.SelectionEvent;
import org.genemania.plugin.selection.SelectionListener;
import org.genemania.plugin.view.util.UiUtils;

public class FunctionInfoPanel
extends JPanel {
    private final JTable table;
    private final DynamicTableModel<AnnotationEntry> model;
    private ViewState options;
    private SelectionListener<Gene> functionListener;
    private final UiUtils uiUtils;

    public FunctionInfoPanel(UiUtils uiUtils) {
        this.uiUtils = uiUtils;
        this.model = new DynamicTableModel<AnnotationEntry>(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return String.class;
                    }
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Strings.functionInfoPanelQValue_label;
                    }
                    case 1: {
                        return Strings.functionInfoPanelCoverage_label;
                    }
                    case 2: {
                        return Strings.functionInfoPanelGoAnnotation_label;
                    }
                }
                return null;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                AnnotationEntry entry = (AnnotationEntry)this.get(rowIndex);
                if (entry == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return String.format("%.2g", entry.getQValue());
                    }
                    case 1: {
                        return String.format("%d/%d", entry.getSampleOccurrences(), entry.getTotalOccurrences());
                    }
                    case 2: {
                        return entry.getDescription();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }
        };
        this.table = new JTable(this.model);
        JScrollPane scrollPane = new JScrollPane(this.table, 20, 30);
        this.setLayout(new GridBagLayout());
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                FunctionInfoPanel.this.updateSelectedNodes();
            }
        });
    }

    private void updateSelectedNodes() {
        if (this.functionListener == null) {
            return;
        }
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        AnnotationEntry entry = this.model.get(row);
        if (entry == null) {
            return;
        }
        Collection<Gene> genes = this.options.getSearchResult().getNodesByAnnotation(entry.getName());
        SelectionEvent<Gene> event = new SelectionEvent<Gene>(new HashSet<Gene>(genes), true);
        this.functionListener.selectionChanged(event);
    }

    public void applyOptions(ViewState options) {
        this.options = options;
        this.model.clear();
        for (AnnotationEntry entry : options.getSearchResult().getEnrichmentSummary()) {
            this.model.add(entry);
        }
        this.uiUtils.packColumns(this.table);
    }

    public void updateSelection(ViewState options) {
        if (options.getTotalHighlightedGenes() == 0) {
            this.table.getSelectionModel().clearSelection();
        }
    }

    public void setSelectionListener(SelectionListener<Gene> functionListener) {
        this.functionListener = functionListener;
    }
}

