/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.genemania.domain.Gene;
import org.genemania.domain.Node;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.selection.SelectionEvent;
import org.genemania.plugin.view.GeneDetailPanel;
import org.genemania.plugin.view.components.ToggleInfoPanel;
import org.genemania.plugin.view.util.UiUtils;

public class GeneInfoPanel
extends ToggleInfoPanel<Gene, GeneDetailPanel> {
    private static final long serialVersionUID = 1L;
    private final NetworkUtils networkUtils;

    public GeneInfoPanel(NetworkUtils networkUtils, UiUtils uiUtils) {
        super(uiUtils);
        this.networkUtils = networkUtils;
    }

    @Override
    public void applyOptions(ViewState options) {
        this.removeAll();
        SearchResult result = options.getSearchResult();
        Map<Gene, Double> scores = result.getScores();
        List<Gene> sortedNodes = this.networkUtils.createSortedList(scores);
        int index = 0;
        for (Gene gene : sortedNodes) {
            double score = scores.get(gene);
            Node node = gene.getNode();
            long nodeId = node.getId();
            boolean isQueryNode = result.isQueryNode(nodeId);
            GeneDetailPanel panel = new GeneDetailPanel(gene, score, isQueryNode, this.networkUtils, this.uiUtils);
            this.addDetailPanel(panel, index);
            ++index;
        }
        this.add(this.uiUtils.createFillerPanel(), new GridBagConstraints(0, index, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.invalidate();
    }

    @Override
    public void updateSelection(ViewState options) {
        GeneDetailPanel mostRecent = null;
        for (GeneDetailPanel panel : this.dataModel) {
            boolean enabled = options.getGeneHighlighted(panel.getGeneName());
            if (enabled) {
                mostRecent = panel;
                panel.showDetails(true, 1);
            }
            panel.setSelected(enabled);
        }
        if (mostRecent != null) {
            this.ensureVisible(mostRecent);
        }
    }

    @Override
    protected void setAllEnabled(boolean enabled) {
        HashSet<Gene> genes = new HashSet<Gene>();
        for (GeneDetailPanel panel : this.dataModel) {
            if (panel.getSelected() == enabled) continue;
            genes.add(panel.getSubject());
            panel.setSelected(enabled);
        }
        this.notifyListeners(new SelectionEvent(genes, enabled));
    }

    @Override
    protected Comparator<GeneDetailPanel> getComparator(final int column, Boolean descending) {
        this.isDescending = descending == null ? !this.isDescending : descending;
        return new Comparator<GeneDetailPanel>(){

            @Override
            public int compare(GeneDetailPanel o1, GeneDetailPanel o2) {
                switch (column) {
                    case 0: {
                        return o1.getSubject().getSymbol().compareTo(o2.getSubject().getSymbol()) * (GeneInfoPanel.this.isDescending ? -1 : 1);
                    }
                    case 1: {
                        if (o1.isQueryGene && o2.isQueryGene) {
                            return o1.getSubject().getSymbol().compareTo(o2.getSubject().getSymbol());
                        }
                        if (o1.isQueryGene) {
                            return -1;
                        }
                        if (o2.isQueryGene) {
                            return 1;
                        }
                        return Double.compare(o1.getScore(), o2.getScore()) * (GeneInfoPanel.this.isDescending ? -1 : 1);
                    }
                }
                throw new RuntimeException(String.format(Strings.tableModelInvalidColumn_error, column));
            }
        };
    }
}

