/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.selection.NetworkSelectionManager;
import org.genemania.plugin.view.NetworkDetailPanel;
import org.genemania.plugin.view.NetworkGroupInfoPanel;
import org.genemania.plugin.view.NetworkInfoPanel;
import org.genemania.plugin.view.components.BaseInfoPanel;
import org.genemania.plugin.view.components.ToggleDetailPanel;
import org.genemania.plugin.view.util.UiUtils;

public class NetworkGroupDetailPanel<NETWORK, NODE, EDGE>
extends ToggleDetailPanel<Group<?, ?>> {
    private static final long serialVersionUID = 1L;
    private final Group<?, ?> group;
    private final NetworkInfoPanel networksPanel;
    private final JToggleButton expander;
    private final JCheckBox toggleBox;
    private final Component fillerPanel;
    private final NetworkUtils networkUtils;
    private final DataSet data;
    private int barXOffset = -1;
    private int barYOffset = -1;

    public NetworkGroupDetailPanel(Group<?, ?> group, NetworkGroupInfoPanel<NETWORK, NODE, EDGE> groupInfoPanel, GeneMania<NETWORK, NODE, EDGE> plugin, NetworkUtils networkUtils, UiUtils uiUtils, boolean enabledByDefault, ViewState options) {
        super(uiUtils);
        this.group = group;
        this.networkUtils = networkUtils;
        this.data = plugin.getDataSetManager().getDataSet();
        this.networksPanel = new NetworkInfoPanel(this.data, group, groupInfoPanel, networkUtils, uiUtils, plugin, options);
        NetworkSelectionManager<NETWORK, NODE, EDGE> manager = plugin.getNetworkSelectionManager();
        this.networksPanel.addSelectionListener(manager.createNetworkSelectionListener());
        Color textColor = group.hasInteractions() ? Color.black : Color.gray;
        this.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.white));
        this.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(group.getName());
        nameLabel.setFont(nameLabel.getFont().deriveFont(1));
        nameLabel.setForeground(textColor);
        JLabel scoreLabel = new JLabel(String.format(Strings.networkScore_label, this.getWeight()));
        scoreLabel.setForeground(textColor);
        this.toggleBox = uiUtils.createCheckBox();
        this.toggleBox.setSelected(enabledByDefault);
        this.toggleBox.addActionListener(manager.createChangeListener(group));
        if (!group.hasInteractions()) {
            this.setEnabled(false);
            this.toggleBox.setSelected(false);
            this.toggleBox.setEnabled(false);
        }
        this.expander = this.createToggleButton();
        this.add((Component)this.expander, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.toggleBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)nameLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)scoreLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.fillerPanel = uiUtils.createFillerPanel(BaseInfoPanel.defaultBackground);
        this.add(this.fillerPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.networksPanel, new GridBagConstraints(2, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.computeBarPosition();
        Color color = this.networkUtils.getNetworkColor(this.data, this.group);
        g.setColor(color);
        int width = (int)((double)(this.getWidth() - this.barXOffset) * this.getWeight() / 100.0);
        for (int y = 0; y < 3; ++y) {
            int yOffset = this.barYOffset - y - 2;
            g.drawLine(this.barXOffset, yOffset, width + this.barXOffset, yOffset);
        }
    }

    private void computeBarPosition() {
        if (this.barXOffset == -1) {
            this.networksPanel.setVisible(true);
            this.doLayout();
            this.barXOffset = this.networksPanel.getX();
            this.barYOffset = this.networksPanel.getY();
            this.networksPanel.setVisible(false);
            this.fillerPanel.setVisible(false);
        }
    }

    @Override
    public Group<?, ?> getSubject() {
        return this.group;
    }

    @Override
    protected void doShowDetails(boolean show, int depth) {
        this.expander.setSelected(show);
        this.networksPanel.setVisible(show);
        this.fillerPanel.setVisible(show);
        if (depth == 0) {
            this.invalidate();
            return;
        }
        for (Component component : this.networksPanel.getComponents()) {
            if (!(component instanceof NetworkDetailPanel)) continue;
            NetworkDetailPanel panel = (NetworkDetailPanel)component;
            panel.showDetails(show, depth - 1);
        }
        this.invalidate();
    }

    public void setItemEnabled(boolean enabled) {
        if (!this.getEnabled() && enabled) {
            return;
        }
        this.toggleBox.setSelected(enabled);
    }

    public double getWeight() {
        return this.networksPanel.getWeight();
    }

    public NetworkInfoPanel getNetworkInfoPanel() {
        return this.networksPanel;
    }
}

