/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Comparator;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.selection.NetworkSelectionManager;
import org.genemania.plugin.selection.SelectionEvent;
import org.genemania.plugin.selection.SelectionListener;
import org.genemania.plugin.view.NetworkGroupDetailPanel;
import org.genemania.plugin.view.components.ToggleDetailPanel;
import org.genemania.plugin.view.components.ToggleInfoPanel;
import org.genemania.plugin.view.util.UiUtils;

public class NetworkGroupInfoPanel<NETWORK, NODE, EDGE>
extends ToggleInfoPanel<Group<?, ?>, NetworkGroupDetailPanel<NETWORK, NODE, EDGE>> {
    private static final long serialVersionUID = 1L;
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;
    private final GeneMania<NETWORK, NODE, EDGE> plugin;
    private final NetworkUtils networkUtils;
    private SelectionListener<Group<?, ?>> selectionListener;

    public NetworkGroupInfoPanel(GeneMania<NETWORK, NODE, EDGE> plugin, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils, NetworkUtils networkUtils, UiUtils uiUtils) {
        super(uiUtils);
        this.plugin = plugin;
        this.cytoscapeUtils = cytoscapeUtils;
        this.networkUtils = networkUtils;
    }

    @Override
    public void applyOptions(final ViewState options) {
        this.removeAll();
        if (this.selectionListener != null) {
            this.removeSelectionListener(this.selectionListener);
        }
        this.selectionListener = new SelectionListener<Group<?, ?>>(){

            @Override
            public void selectionChanged(SelectionEvent<Group<?, ?>> event) {
                if (event.selected) {
                    return;
                }
                for (Group group : event.items) {
                    for (Network network : group.getNetworks()) {
                        options.setNetworkHighlighted(network, false);
                    }
                }
                for (NetworkGroupDetailPanel panel : NetworkGroupInfoPanel.this.dataModel) {
                    panel.getNetworkInfoPanel().updateSelection(options);
                }
            }
        };
        this.addSelectionListener(this.selectionListener);
        int index = 0;
        NETWORK network = this.cytoscapeUtils.getCurrentNetwork();
        for (Group<?, ?> group : options.getAllGroups()) {
            if (group.getWeight() == 0.0) continue;
            boolean enabledByDefault = options.getEnabled(group);
            NetworkGroupDetailPanel<NETWORK, NODE, EDGE> panel = new NetworkGroupDetailPanel<NETWORK, NODE, EDGE>(group, this, this.plugin, this.networkUtils, this.uiUtils, enabledByDefault, options);
            this.addDetailPanel(panel, index);
            ++index;
            this.cytoscapeUtils.setHighlight(options, group, network, enabledByDefault);
        }
        this.add(this.uiUtils.createFillerPanel(), new GridBagConstraints(0, index, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.sort(1, true);
        this.invalidate();
    }

    @Override
    public void updateSelection(ViewState options) {
        NETWORK cyNetwork = this.cytoscapeUtils.getCurrentNetwork();
        if (cyNetwork == null) {
            return;
        }
        int totalEnabled = 0;
        ToggleDetailPanel mostRecent = null;
        Group<?, ?> mostRecentGroup = options.getMostRecentGroup();
        for (NetworkGroupDetailPanel panel : this.dataModel) {
            Object group = panel.getSubject();
            boolean enabled = options.getGroupHighlighted((Group<?, ?>)group);
            if (enabled) {
                ++totalEnabled;
                panel.showDetails(true, 1);
            }
            panel.setItemEnabled(options.getEnabled((Group<?, ?>)group));
            panel.setSelected(enabled);
            if (group.equals(mostRecentGroup)) {
                mostRecent = panel;
            }
            panel.getNetworkInfoPanel().updateSelection(options);
        }
        if (totalEnabled == 0) {
            this.cytoscapeUtils.setHighlighted(options, cyNetwork, false);
            options.clearHighlightedNetworks();
            mostRecent = null;
        }
        if (mostRecent != null) {
            this.ensureVisible(mostRecent);
            mostRecent.showDetails(true, 1);
        }
    }

    @Override
    protected void setAllEnabled(boolean enabled) {
        for (NetworkGroupDetailPanel panel : this.dataModel) {
            panel.setItemEnabled(enabled);
        }
        NETWORK cyNetwork = this.cytoscapeUtils.getCurrentNetwork();
        NetworkSelectionManager<NETWORK, NODE, EDGE> selectionManager = this.plugin.getNetworkSelectionManager();
        ViewState options = selectionManager.getNetworkConfiguration(cyNetwork);
        this.cytoscapeUtils.setHighlight(options, null, cyNetwork, enabled);
    }

    @Override
    protected Comparator<NetworkGroupDetailPanel<NETWORK, NODE, EDGE>> getComparator(final int column, Boolean descending) {
        this.isDescending = descending == null ? !this.isDescending : descending;
        return new Comparator<NetworkGroupDetailPanel<NETWORK, NODE, EDGE>>(){

            @Override
            public int compare(NetworkGroupDetailPanel<NETWORK, NODE, EDGE> o1, NetworkGroupDetailPanel<NETWORK, NODE, EDGE> o2) {
                switch (column) {
                    case 0: {
                        return o1.getSubject().getName().compareTo(o2.getSubject().getName()) * (NetworkGroupInfoPanel.this.isDescending ? -1 : 1);
                    }
                    case 1: {
                        return Double.compare(o1.getWeight(), o2.getWeight()) * (NetworkGroupInfoPanel.this.isDescending ? -1 : 1);
                    }
                }
                throw new RuntimeException(String.format(Strings.tableModelInvalidColumn_error, column));
            }
        };
    }

    @Override
    public void sort(int column, Boolean descending) {
        super.sort(column, descending);
        for (NetworkGroupDetailPanel panel : this.dataModel) {
            panel.getNetworkInfoPanel().sort(column, descending);
        }
    }
}

