/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Comparator;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.selection.SelectionEvent;
import org.genemania.plugin.selection.SelectionListener;
import org.genemania.plugin.view.NetworkDetailPanel;
import org.genemania.plugin.view.NetworkGroupInfoPanel;
import org.genemania.plugin.view.components.BaseInfoPanel;
import org.genemania.plugin.view.components.ToggleInfoPanel;
import org.genemania.plugin.view.util.UiUtils;

public class NetworkInfoPanel
extends ToggleInfoPanel<Network<?>, NetworkDetailPanel> {
    private double weight;

    public NetworkInfoPanel(DataSet data, Group<?, ?> group, final NetworkGroupInfoPanel<?, ?, ?> groupInfoPanel, NetworkUtils networkUtils, UiUtils uiUtils, GeneMania<?, ?, ?> geneMania, final ViewState options) {
        super(uiUtils);
        this.setBackground(BaseInfoPanel.defaultBackground);
        int index = 0;
        for (Network<?> network : group.getNetworks()) {
            double networkWeight = network.getWeight() * 100.0;
            this.weight += networkWeight;
            NetworkDetailPanel panel = new NetworkDetailPanel(network, group, networkUtils, uiUtils, data);
            this.addDetailPanel(panel, index);
            ++index;
        }
        this.add(uiUtils.createFillerPanel(), new GridBagConstraints(0, index, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.invalidate();
        this.addSelectionListener(new SelectionListener<Network<?>>(){

            @Override
            public void selectionChanged(SelectionEvent<Network<?>> event) {
                for (Network network : event.items) {
                    options.setNetworkHighlighted(network, event.selected);
                }
                for (Group group : options.getAllGroups()) {
                    options.setGroupHighlighted(group, false);
                }
                groupInfoPanel.updateSelection(options);
            }
        });
    }

    @Override
    public void applyOptions(ViewState options) {
    }

    @Override
    protected Comparator<NetworkDetailPanel> getComparator(final int column, Boolean descending) {
        this.isDescending = descending == null ? !this.isDescending : descending;
        return new Comparator<NetworkDetailPanel>(){

            @Override
            public int compare(NetworkDetailPanel o1, NetworkDetailPanel o2) {
                switch (column) {
                    case 0: {
                        return o1.getSubject().getName().compareTo(o2.getSubject().getName()) * (NetworkInfoPanel.this.isDescending ? -1 : 1);
                    }
                    case 1: {
                        return Double.compare(o1.getWeight(), o2.getWeight()) * (NetworkInfoPanel.this.isDescending ? -1 : 1);
                    }
                }
                throw new RuntimeException(String.format(Strings.tableModelInvalidColumn_error, column));
            }
        };
    }

    @Override
    protected void setAllEnabled(boolean enabled) {
    }

    @Override
    public void updateSelection(ViewState options) {
        for (NetworkDetailPanel panel : this.dataModel) {
            Object network = panel.getSubject();
            panel.setHighlighted(options.getNetworkHighlighted((Network<?>)network));
        }
    }

    public double getWeight() {
        return this.weight;
    }
}

