/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class ImageCache {
    public static final String ARROW_COLLAPSED_IMAGE = "arrow_collapsed.gif";
    public static final String ARROW_EXPANDED_IMAGE = "arrow_expanded.gif";
    public static final String ICON = "helix.png";
    private Map<String, ImageIcon> iconCache = new HashMap<String, ImageIcon>();
    private Map<String, Image> imageCache = new HashMap<String, Image>();

    public ImageIcon getIcon(String resourcePath) {
        ImageIcon icon = this.iconCache.get(resourcePath);
        if (icon != null) {
            return icon;
        }
        URL imageUrl = this.getClass().getResource(resourcePath);
        if (imageUrl == null && (imageUrl = this.getClass().getClassLoader().getResource(resourcePath)) == null) {
            return null;
        }
        icon = new ImageIcon(imageUrl);
        this.iconCache.put(resourcePath, icon);
        return icon;
    }

    public Image getImage(String resourcePath) {
        Image image = this.imageCache.get(resourcePath);
        if (image != null) {
            return image;
        }
        URL imageUrl = this.getClass().getResource(resourcePath);
        if (imageUrl == null && (imageUrl = this.getClass().getClassLoader().getResource(resourcePath)) == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        image = toolkit.getImage(imageUrl);
        this.imageCache.put(resourcePath, image);
        return image;
    }
}

