/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.axis.AxisType;
import com.jidesoft.chart.fit.CurveFitter;
import com.jidesoft.chart.fit.Polynomial;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.Range;
import java.awt.geom.Point2D;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineFitter
implements CurveFitter {
    private static LineFitter a;

    private LineFitter() {
    }

    public static LineFitter getInstance() {
        LineFitter lineFitter = a;
        if (Polynomial.b == 0) {
            if (lineFitter == null) {
                a = new LineFitter();
            }
            lineFitter = a;
        }
        return lineFitter;
    }

    @Override
    public AnnotatedChartModel performRegression(String string, ChartModel chartModel, Range<?> range, int n) {
        Polynomial polynomial = this.performRegression(chartModel);
        return this.createModel(string, polynomial, range, 2);
    }

    @Override
    public AnnotatedChartModel createModel(Polynomial polynomial, Range<?> range, int n) {
        return this.createModel(null, polynomial, range, n);
    }

    @Override
    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Range<?> range, int n) {
        double d2 = range.minimum();
        double d3 = range.maximum();
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        defaultChartModel.addPoint(d2, polynomial.eval(d2));
        defaultChartModel.addPoint(d3, polynomial.eval(d3));
        return defaultChartModel;
    }

    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Double[] doubleArray) {
        DefaultChartModel defaultChartModel;
        block2: {
            int n = Polynomial.b;
            DefaultChartModel defaultChartModel2 = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
            for (Double d2 : doubleArray) {
                double d3 = polynomial.eval(d2);
                defaultChartModel = defaultChartModel2.addPoint((double)d2, d3);
                if (n == 0) {
                    if (n == 0) continue;
                }
                break block2;
            }
            defaultChartModel = defaultChartModel2;
        }
        return defaultChartModel;
    }

    @Override
    public Polynomial performRegression(ChartModel chartModel) {
        double d2 = this.a(AxisType.x, chartModel);
        double d3 = this.a(AxisType.y, chartModel);
        double d4 = this.a(chartModel, d2, d3);
        double d5 = this.a(d2, d3, d4);
        return new Polynomial(d5, d4);
    }

    public Polynomial performRegression(Collection<? extends Point2D> collection) {
        double d2 = this.a(AxisType.x, collection);
        double d3 = this.a(AxisType.y, collection);
        double d4 = this.a(collection, d2, d3);
        double d5 = this.a(d2, d3, d4);
        return new Polynomial(d5, d4);
    }

    private double a(ChartModel chartModel, double d2, double d3) {
        double d4;
        block2: {
            int n = Polynomial.b;
            double d5 = 0.0;
            double d6 = 0.0;
            for (Chartable chartable : chartModel) {
                double d7 = chartable.getX().position() - d2;
                double d8 = chartable.getY().position() - d3;
                d5 += d7 * d8;
                d4 = d6 + d7 * d7;
                if (n == 0) {
                    d6 = d4;
                    if (n == 0) continue;
                }
                break block2;
            }
            d4 = d5 / d6;
        }
        return d4;
    }

    private double a(Collection<? extends Point2D> collection, double d2, double d3) {
        double d4;
        block2: {
            int n = Polynomial.b;
            double d5 = 0.0;
            double d6 = 0.0;
            for (Point2D point2D : collection) {
                double d7 = point2D.getX() - d2;
                double d8 = point2D.getY() - d3;
                d5 += d7 * d8;
                d4 = d6 + d7 * d7;
                if (n == 0) {
                    d6 = d4;
                    if (n == 0) continue;
                }
                break block2;
            }
            d4 = d5 / d6;
        }
        return d4;
    }

    private double a(double d2, double d3, double d4) {
        return d3 - d4 * d2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double a(AxisType axisType, ChartModel chartModel) {
        double d2;
        double d3;
        block7: {
            int n;
            block8: {
                n = Polynomial.b;
                d3 = 0.0;
                if (axisType != AxisType.x) break block8;
                for (Chartable chartable : chartModel) {
                    d3 += chartable.getX().position();
                    if (n == 0) {
                        if (n == 0) continue;
                    }
                    break block7;
                }
                if (n == 0) break block7;
            }
            for (Chartable chartable : chartModel) {
                d2 = d3 + chartable.getY().position();
                if (n != 0) return d2;
                d3 = d2;
                if (n == 0) continue;
            }
        }
        d2 = d3 / (double)chartModel.getPointCount();
        return d2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double a(AxisType axisType, Collection<? extends Point2D> collection) {
        double d2;
        double d3;
        block7: {
            int n;
            block8: {
                n = Polynomial.b;
                d3 = 0.0;
                if (axisType != AxisType.x) break block8;
                for (Point2D point2D : collection) {
                    d3 += point2D.getX();
                    if (n == 0) {
                        if (n == 0) continue;
                    }
                    break block7;
                }
                if (n == 0) break block7;
            }
            for (Point2D point2D : collection) {
                d2 = d3 + point2D.getY();
                if (n != 0) return d2;
                d3 = d2;
                if (n == 0) continue;
            }
        }
        d2 = d3 / (double)collection.size();
        return d2;
    }
}

