/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.cytoscape2;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.CytoscapeVersion;
import cytoscape.plugin.CytoscapePlugin;
import java.util.Collections;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.cytoscape2.CompatibilityImpl;
import org.genemania.plugin.cytoscape2.CytoscapeUtilsImpl;
import org.genemania.plugin.cytoscape2.FileUtilsImpl;
import org.genemania.plugin.cytoscape2.GeneManiaImpl;
import org.genemania.plugin.cytoscape2.support.Compatibility;
import org.genemania.plugin.cytoscape26.Cy26Compatibility;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.IDataSetFactory;
import org.genemania.plugin.data.lucene.LuceneDataSetFactory;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.util.UiUtils;

public class GeneManiaPlugin
extends CytoscapePlugin {
    private GeneManiaImpl geneMania;
    private Object mutex = new Object();
    private boolean activated;

    public GeneManiaPlugin() {
        this.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.activated) {
                return;
            }
            UiUtils uiUtils = new UiUtils();
            FileUtilsImpl fileUtils = new FileUtilsImpl();
            NetworkUtils networkUtils = new NetworkUtils();
            CytoscapeVersion version = new CytoscapeVersion();
            Compatibility compatibility = this.createCompatibility(version);
            CytoscapeUtilsImpl cytoscapeUtils = new CytoscapeUtilsImpl(networkUtils, compatibility);
            TaskDispatcher taskDispatcher = new TaskDispatcher(uiUtils);
            DataSetManager dataSetManager = new DataSetManager();
            dataSetManager.addDataSetFactory((IDataSetFactory)new LuceneDataSetFactory(dataSetManager, uiUtils, (FileUtils)fileUtils, (CytoscapeUtils)cytoscapeUtils, taskDispatcher), Collections.emptyMap());
            this.geneMania = new GeneManiaImpl(dataSetManager, (CytoscapeUtils<CyNetwork, CyNode, CyEdge>)cytoscapeUtils, uiUtils, fileUtils, networkUtils, taskDispatcher);
            this.geneMania.startUp();
            this.activated = true;
        }
    }

    private Compatibility createCompatibility(CytoscapeVersion version) {
        String[] parts = version.getMajorVersion().split("[.]");
        if (!parts[0].equals("2")) {
            throw new RuntimeException(Strings.cy2_geneManiaPlugin_error);
        }
        int minorVersion = Integer.parseInt(parts[1]);
        if (minorVersion < 8) {
            return new Cy26Compatibility();
        }
        return new CompatibilityImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Object object = this.mutex;
        synchronized (object) {
            this.geneMania.shutDown();
            this.activated = false;
        }
    }
}

