/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.cytoscape2.actions;

import cytoscape.util.CytoscapeAction;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelState;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;

public abstract class ShowCytoPanelAction<T extends JPanel>
extends CytoscapeAction {
    public static final String SHOW = "show";
    public static final String HIDE = "hide";
    private static final long serialVersionUID = 1L;
    private final Object mutex = new Object();
    private T panel;
    private boolean visible;

    public ShowCytoPanelAction(String name) {
        super(name);
    }

    public void actionPerformed(ActionEvent e) {
        if (e != null && SHOW.equals(e.getActionCommand())) {
            this.showPanel();
        } else if (e != null && HIDE.equals(e.getActionCommand())) {
            this.hidePanel();
        } else if (this.visible) {
            this.hidePanel();
        } else {
            this.showPanel();
        }
    }

    protected boolean isVisible() {
        return this.visible;
    }

    public void hidePanel() {
        CytoPanel cytoPanel = this.getCytoPanel();
        int index = cytoPanel.indexOfComponent(this.getPanel());
        if (index != -1) {
            cytoPanel.remove(index);
        }
        if (this.visible) {
            this.visible = false;
            this.handleVisibilityChange(this.visible);
        }
    }

    public void showPanel() {
        CytoPanel cytoPanel = this.getCytoPanel();
        int index = cytoPanel.indexOfComponent(this.getPanel());
        if (index == -1) {
            this.addPanel();
        } else {
            cytoPanel.setSelectedIndex(index);
        }
        if (!this.visible) {
            this.visible = true;
            this.handleVisibilityChange(this.visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getPanel() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.panel == null) {
                this.panel = this.createPanel();
                this.addPanel();
            }
        }
        return this.panel;
    }

    void addPanel() {
        CytoPanel cytoPanel = this.getCytoPanel();
        cytoPanel.add(((Component)this.panel).getName(), this.panel);
        cytoPanel.setState(CytoPanelState.DOCK);
    }

    public abstract CytoPanel getCytoPanel();

    protected abstract T createPanel();

    protected abstract void handleVisibilityChange(boolean var1);
}

