/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.expression.AbstractExpression;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.ExpressionVisitor;
import com.jidesoft.thirdparty.prefuse.data.expression.Function;
import com.jidesoft.thirdparty.prefuse.util.collections.CopyOnWriteArrayList;

public abstract class FunctionExpression
extends AbstractExpression
implements Function {
    protected CopyOnWriteArrayList m_params;
    protected final int m_pcount;

    protected FunctionExpression(int n2) {
        this.m_pcount = n2;
    }

    public abstract String getName();

    public void addParameter(Expression expression) {
        int n2 = this.getParameterCount();
        if (n2 != -1 && this.paramCount() + 1 > n2) {
            throw new IllegalStateException("This function takes only " + n2 + " parameters.");
        }
        if (this.m_params == null) {
            this.m_params = new CopyOnWriteArrayList();
        }
        this.m_params.add(expression);
    }

    protected int paramCount() {
        return this.m_params == null ? 0 : this.m_params.size();
    }

    protected final Expression param(int n2) {
        return (Expression)this.m_params.get(n2);
    }

    public int getParameterCount() {
        return this.m_pcount;
    }

    protected void missingParams() {
        throw new IllegalStateException("Function is missing parameters: " + this.getName());
    }

    public void visit(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visitExpression(this);
        if (this.paramCount() > 0) {
            Object[] objectArray = this.m_params.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                expressionVisitor.down();
                ((Expression)objectArray[i2]).visit(expressionVisitor);
                expressionVisitor.up();
            }
        }
    }

    protected void addChildListeners() {
        if (this.paramCount() > 0) {
            Object[] objectArray = this.m_params.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ((Expression)objectArray[i2]).addExpressionListener(this);
            }
        }
    }

    protected void removeChildListeners() {
        if (this.paramCount() > 0) {
            Object[] objectArray = this.m_params.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ((Expression)objectArray[i2]).removeExpressionListener(this);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName()).append('(');
        for (int i2 = 0; i2 < this.paramCount(); ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.param(i2).toString());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

