/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.parser;

import com.jidesoft.thirdparty.prefuse.data.parser.DataParseException;
import com.jidesoft.thirdparty.prefuse.data.parser.DataParser;

public class BooleanParser
implements DataParser {
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public Class getType() {
        return Boolean.TYPE;
    }

    public String format(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Boolean)) {
            throw new IllegalArgumentException("This class can only format Objects of type Boolean.");
        }
        return ((Boolean)object).toString();
    }

    public boolean canParse(String string) {
        return TRUE.equalsIgnoreCase(string) || FALSE.equalsIgnoreCase(string);
    }

    public Object parse(String string) throws DataParseException {
        return this.parseBoolean(string) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean parseBoolean(String string) throws DataParseException {
        if (TRUE.equalsIgnoreCase(string)) {
            return true;
        }
        if (FALSE.equalsIgnoreCase(string)) {
            return false;
        }
        throw new DataParseException("Input does not represent a boolean value: " + string);
    }
}

