/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.util.StringUtils;

public class TDFBedTile
implements TDFTile {
    int tileStart;
    private int[] start;
    private int[] end;
    private float[][] data;
    private String[] names;

    public TDFBedTile(ByteBuffer byteBuffer, int nSamples, TDFTile.Type type) throws IOException {
        this.fill(byteBuffer, nSamples, type);
    }

    public TDFBedTile(int tileStart, int[] start, int[] end, float[][] data) {
        this.tileStart = tileStart;
        this.start = start;
        this.end = end;
        this.data = data;
    }

    public TDFBedTile(int tileStart, int[] start, int[] end, float[][] data, String[] name) {
        this(tileStart, start, end, data);
        this.names = name;
    }

    @Override
    public int getSize() {
        return this.start.length;
    }

    @Override
    public int getTileStart() {
        return this.tileStart;
    }

    public int getTileEnd() {
        return this.getSize() == 0 ? 0 : this.getEndPosition(this.getSize() - 1);
    }

    @Override
    public int getStartPosition(int idx) {
        return this.start[idx];
    }

    @Override
    public int getEndPosition(int idx) {
        return this.end[idx];
    }

    @Override
    public String getName(int idx) {
        return this.names == null ? null : this.names[idx];
    }

    @Override
    public float getValue(int row, int idx) {
        return this.data[row][idx];
    }

    @Override
    public void writeTo(BufferedByteWriter fos) throws IOException {
        int i;
        TDFTile.Type type = this.names == null ? TDFTile.Type.bed : TDFTile.Type.bedWithName;
        fos.putNullTerminatedString(type.toString());
        int nPositions = this.start.length;
        int nSamples = this.data.length;
        fos.putInt(nPositions);
        for (i = 0; i < nPositions; ++i) {
            fos.putInt(this.start[i]);
        }
        for (i = 0; i < nPositions; ++i) {
            fos.putInt(this.end[i]);
        }
        fos.putInt(nSamples);
        for (i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[i].length; ++j) {
                fos.putFloat(this.data[i][j]);
            }
        }
        if (type == TDFTile.Type.bedWithName) {
            for (i = 0; i < nPositions; ++i) {
                fos.putNullTerminatedString(this.names[i]);
            }
        }
    }

    private void fill(ByteBuffer byteBuffer, int nSamples, TDFTile.Type type) throws IOException {
        int i;
        int nPositions = byteBuffer.getInt();
        this.start = new int[nPositions];
        for (i = 0; i < nPositions; ++i) {
            this.start[i] = byteBuffer.getInt();
        }
        this.end = new int[nPositions];
        for (i = 0; i < nPositions; ++i) {
            this.end[i] = byteBuffer.getInt();
        }
        int nS = byteBuffer.getInt();
        assert (nS == nSamples);
        this.data = new float[nS][nPositions];
        for (int row = 0; row < nS; ++row) {
            this.data[row] = new float[nPositions];
            for (int i2 = 0; i2 < nPositions; ++i2) {
                this.data[row][i2] = byteBuffer.getFloat();
            }
        }
        if (type == TDFTile.Type.bedWithName) {
            this.names = new String[nPositions];
            for (int i3 = 0; i3 < nPositions; ++i3) {
                this.names[i3] = StringUtils.readString(byteBuffer);
            }
        }
    }

    @Override
    public int[] getStart() {
        return this.start;
    }

    @Override
    public int[] getEnd() {
        return this.end;
    }

    @Override
    public float[] getData(int trackNumber) {
        return this.data[trackNumber];
    }

    @Override
    public String[] getNames() {
        return this.names;
    }
}

