/*
 * Decompiled with CFR 0.152.
 */
package savant.api.util;

import savant.api.adapter.BookmarkAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.event.BookmarksChangedEvent;
import savant.api.util.Listener;
import savant.controller.BookmarkController;
import savant.util.Bookmark;
import savant.util.Range;

public class BookmarkUtils {
    private static BookmarkController controller = BookmarkController.getInstance();

    public static BookmarkAdapter[] getBookmarks() {
        return controller.getBookmarks().toArray(new BookmarkAdapter[0]);
    }

    public static void addBookmark(BookmarkAdapter value) {
        controller.addBookmark((Bookmark)value);
    }

    public static void removeLastBookmark() {
        controller.removeBookmark();
    }

    public static void removeBookmark(int index) {
        controller.removeBookmark(index);
    }

    public static void addBookmarksChangedListener(Listener<BookmarksChangedEvent> l) {
        controller.addListener(l);
    }

    public static void removeBookmarksChangedListener(Listener<BookmarksChangedEvent> l) {
        controller.removeListener(l);
    }

    public static void addCurrentRangeToBookmarks() {
        controller.addCurrentRangeToBookmarks();
    }

    public static BookmarkAdapter getBookmark(int index) {
        return controller.getBookmark(index);
    }

    public static void clearBookmarks() {
        controller.clearBookmarks();
    }

    public static BookmarkAdapter createBookmark(String ref, RangeAdapter range) {
        return new Bookmark(ref, (Range)range);
    }

    public static BookmarkAdapter createBookmark(String ref, RangeAdapter range, String ann) {
        return new Bookmark(ref, (Range)range, ann);
    }

    public static BookmarkAdapter createBookmark(String ref, RangeAdapter range, String ann, boolean addMargin) {
        return new Bookmark(ref, (Range)range, ann, addMargin);
    }
}

