/*
 * Decompiled with CFR 0.152.
 */
package savant.controller;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.event.GenomeChangedEvent;
import savant.api.event.TrackEvent;
import savant.api.util.Listener;
import savant.controller.TrackController;
import savant.data.types.Genome;
import savant.util.Controller;
import savant.view.tracks.SequenceTrack;

public class GenomeController
extends Controller<GenomeChangedEvent> {
    private static final Log LOG = LogFactory.getLog(GenomeController.class);
    private static GenomeController instance;
    private Genome loadedGenome;

    public static GenomeController getInstance() {
        if (instance == null) {
            instance = new GenomeController();
            TrackController.getInstance().addListener(new Listener<TrackEvent>(){

                @Override
                public void handleEvent(TrackEvent event) {
                    if (event.getType() == TrackEvent.Type.REMOVED && instance.loadedGenome != null && event.getTrack() == instance.loadedGenome.getSequenceTrack()) {
                        instance.setSequence(null);
                    }
                }
            });
        }
        return instance;
    }

    private GenomeController() {
    }

    public Genome getGenome() {
        return this.loadedGenome;
    }

    public boolean isGenomeLoaded() {
        return this.loadedGenome != null;
    }

    public synchronized void setGenome(Genome genome) {
        if (genome == null) {
            this.loadedGenome = null;
        } else {
            Genome oldGenome = this.loadedGenome;
            if (!genome.equals(oldGenome)) {
                this.loadedGenome = genome;
                this.fireEvent(new GenomeChangedEvent(oldGenome, this.loadedGenome));
            }
        }
    }

    public synchronized void setSequence(SequenceTrack t) {
        if (this.loadedGenome == null) {
            this.setGenome(Genome.createFromTrack(t));
        } else if (!this.loadedGenome.isSequenceSet()) {
            this.loadedGenome.setSequenceTrack(t);
            LOG.info((Object)("Firing sequence set/unset event for " + this.loadedGenome));
            this.fireEvent(new GenomeChangedEvent(this.loadedGenome, this.loadedGenome));
        }
    }
}

