/*
 * Decompiled with CFR 0.152.
 */
package savant.controller;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.event.GenomeChangedEvent;
import savant.api.event.LocationChangedEvent;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.controller.GenomeController;
import savant.controller.GraphPaneController;
import savant.controller.TrackController;
import savant.data.types.Genome;
import savant.util.Controller;
import savant.util.Range;

public class LocationController
extends Controller<LocationChangedEvent>
implements Listener<GenomeChangedEvent> {
    private static LocationController instance;
    private static final Log LOG;
    private String currentReference;
    private Stack<History> undoStack = new Stack();
    private Stack<History> redoStack = new Stack();
    private int maxUndoStackSize = 50;
    private boolean shouldClearRedoStack = true;
    private Range maximumViewableRange;
    private Range currentViewableRange;
    private String pendingReference;
    private Range pendingRange;

    public static synchronized LocationController getInstance() {
        if (instance == null) {
            instance = new LocationController();
            GenomeController.getInstance().addListener(instance);
        }
        return instance;
    }

    private LocationController() {
    }

    public void setLocation(String ref, boolean forceEvent) {
        if (this.isValidAndNewReference(ref) || forceEvent) {
            this.updateHistory();
            this.setReference(ref);
            this.fireEvent(new LocationChangedEvent(true, this.currentReference, this.currentViewableRange));
        }
    }

    public void setLocation(Range r) {
        if (!r.equals(this.currentViewableRange)) {
            this.updateHistory();
            this.setRange(r);
            this.fireEvent(new LocationChangedEvent(false, this.currentReference, this.currentViewableRange));
        }
    }

    public void setLocation(int from, int to) {
        this.setLocation(new Range(from, to));
    }

    public void setLocation(String ref, Range range) {
        if (GenomeController.getInstance().isGenomeLoaded()) {
            boolean rangeChanging;
            boolean refChanging = this.isValidAndNewReference(ref);
            boolean bl = rangeChanging = !range.equals(this.currentViewableRange);
            if (refChanging || rangeChanging) {
                this.updateHistory();
                if (refChanging) {
                    this.setReference(ref);
                }
                if (rangeChanging) {
                    this.setRange(range);
                }
                this.fireEvent(new LocationChangedEvent(refChanging, this.currentReference, this.currentViewableRange));
            }
            this.pendingReference = null;
            this.pendingRange = null;
        } else {
            this.pendingReference = ref;
            this.pendingRange = range;
        }
    }

    private void setLocation(History history) {
        this.setLocation(history.reference, history.range);
    }

    private void setReference(String ref) {
        Set<String> allRefs = this.getAllReferenceNames();
        if (!allRefs.contains(ref) && allRefs.contains("chr" + ref)) {
            ref = "chr" + ref;
        }
        this.currentReference = ref;
        Genome loadedGenome = GenomeController.getInstance().getGenome();
        this.setMaxRange(new Range(1, loadedGenome.getLength()));
        this.setRange(1, Math.min(1000, loadedGenome.getLength()));
    }

    private boolean isValidAndNewReference(String ref) {
        Set<String> allRefs = this.getAllReferenceNames();
        if (allRefs.contains(ref)) {
            if (!ref.equals(this.currentReference)) {
                return true;
            }
        } else {
            if (allRefs.contains("chr" + ref)) {
                return this.isValidAndNewReference("chr" + ref);
            }
            if (TrackController.getInstance().getTracks().size() > 0) {
                DialogUtils.displayMessage(String.format("<html>Reference <i>%s</i> not found in loaded tracks.</html>", ref));
            }
        }
        return false;
    }

    public String getReferenceName() {
        return this.currentReference;
    }

    public Set<String> getAllReferenceNames() {
        HashSet<String> all = new HashSet<String>();
        all.addAll(GenomeController.getInstance().getGenome().getReferenceNames());
        all.addAll(this.getNonGenomicReferenceNames());
        return all;
    }

    public Set<String> getReferenceNames() {
        return GenomeController.getInstance().getGenome().getReferenceNames();
    }

    public int getReferenceLength(String refname) {
        return GenomeController.getInstance().getGenome().getLength(refname);
    }

    public Set<String> getNonGenomicReferenceNames() {
        return new HashSet<String>();
    }

    private void setRange(int from, int to) {
        this.setRange(new Range(from, to));
    }

    private void setRange(Range r) {
        int diff;
        LOG.debug((Object)("Setting range to " + r));
        int from = r.getFrom();
        int to = r.getTo();
        if (from < this.getMaxRangeStart()) {
            diff = this.getMaxRangeStart() - from;
            from = this.getMaxRangeStart();
            to += diff;
        }
        if (to > this.getMaxRangeEnd()) {
            diff = to - this.getMaxRangeEnd();
            to = this.getMaxRangeEnd();
            from -= diff;
        }
        if (from < this.getMaxRangeStart()) {
            from = this.getMaxRangeStart();
            to = this.getMaxRangeEnd();
        }
        this.currentViewableRange = r = new Range(from, to);
        System.gc();
    }

    public void setMaxRange(Range r) {
        this.maximumViewableRange = r;
        LOG.debug((Object)("Setting maximum range to " + r));
    }

    public Range getMaxRange() {
        return this.maximumViewableRange;
    }

    public int getMaxRangeStart() {
        return this.maximumViewableRange.getFrom();
    }

    public int getMaxRangeEnd() {
        return this.maximumViewableRange.getTo();
    }

    public Range getRange() {
        return this.currentViewableRange;
    }

    public int getRangeStart() {
        return this.currentViewableRange.getFrom();
    }

    public int getRangeEnd() {
        return this.currentViewableRange.getTo();
    }

    public void shiftRangeLeft() {
        this.shiftRange(false, 0.5);
    }

    public void shiftRangeRight() {
        this.shiftRange(true, 0.5);
    }

    public void shiftRange(boolean shiftRight, double percentwindow) {
        Range r = this.getRange();
        int length = r.getLength();
        int direction = 1;
        if (!shiftRight) {
            direction = -1;
        }
        int shift = (int)Math.ceil((double)direction * (percentwindow * (double)length)) - (direction == -1 && length == 1 ? 1 : 0);
        r = new Range(r.getFrom() + shift, r.getTo() + shift);
        this.setLocation(r);
    }

    public void shiftRangeFarLeft() {
        Range r = new Range(1, this.getRange().getLength());
        this.setLocation(r);
    }

    public void shiftRangeFarRight() {
        Range r = new Range(this.getMaxRangeEnd() - this.getRange().getLength() + 1, this.getMaxRangeEnd());
        this.setLocation(r);
    }

    public void zoomToLength(int length) {
        this.zoomToLength(length, (this.getRangeEnd() + 1 + this.getRangeStart()) / 2);
    }

    public void zoomToLength(int length, int center) {
        length = Math.min(length, this.maximumViewableRange.getLength());
        length = Math.max(length, 1);
        LOG.debug((Object)("Zooming to length " + length));
        if (length > this.getMaxRangeEnd()) {
            return;
        }
        int half = Math.max(length / 2, 1);
        Range rg = new Range(center - half, center - half + length - 1);
        this.setLocation(rg);
    }

    public void zoomOut() {
        this.zoomToLength(this.currentViewableRange.getLength() * 2);
    }

    public void zoomIn() {
        if (this.currentViewableRange.getLength() > 1) {
            this.zoomToLength(this.currentViewableRange.getLength() / 2);
        }
    }

    public void zoomInOnMouse() {
        int center = GraphPaneController.getInstance().getMouseXPosition();
        this.zoomToLength(this.currentViewableRange.getLength() / 2, center);
    }

    public void zoomOutFromMouse() {
        int center = GraphPaneController.getInstance().getMouseXPosition();
        this.zoomToLength(this.currentViewableRange.getLength() * 2, center);
    }

    private void updateHistory() {
        if (this.shouldClearRedoStack && this.currentViewableRange != null && this.currentReference != null) {
            this.redoStack.clear();
            this.undoStack.push(new History(this.currentReference, this.currentViewableRange));
            while (this.undoStack.size() > this.maxUndoStackSize) {
                this.undoStack.remove(0);
            }
        }
    }

    public void undoLocationChange() {
        if (this.undoStack.size() > 0) {
            this.shouldClearRedoStack = false;
            this.redoStack.push(new History(this.currentReference, this.currentViewableRange));
            this.setLocation(this.undoStack.pop());
            this.shouldClearRedoStack = true;
        }
    }

    public void redoLocationChange() {
        if (this.redoStack.size() > 0) {
            this.shouldClearRedoStack = false;
            this.undoStack.push(new History(this.currentReference, this.currentViewableRange));
            this.setLocation(this.redoStack.pop());
            this.shouldClearRedoStack = true;
        }
    }

    @Override
    public void handleEvent(GenomeChangedEvent event) {
        if (this.pendingReference != null) {
            this.setLocation(this.pendingReference, this.pendingRange);
        } else if (event.getNewGenome() != event.getOldGenome()) {
            String ref = event.getNewGenome().getReferenceNames().iterator().next();
            this.setLocation(ref, true);
        }
    }

    static {
        LOG = LogFactory.getLog(LocationController.class);
    }

    private class History {
        public Range range;
        public String reference;

        public History(String ref, Range range) {
            this.range = range;
            this.reference = ref;
        }
    }
}

