/*
 * Decompiled with CFR 0.152.
 */
package savant.controller;

import java.net.Authenticator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;
import savant.api.data.DataFormat;
import savant.api.event.TrackEvent;
import savant.controller.FrameController;
import savant.util.Controller;
import savant.util.SavantHTTPAuthenticator;
import savant.view.tracks.Track;

public class TrackController
extends Controller<TrackEvent> {
    private static final Log LOG = LogFactory.getLog(TrackController.class);
    private static TrackController instance;
    List<Track> tracks = new ArrayList<Track>();

    public static synchronized TrackController getInstance() {
        if (instance == null) {
            instance = new TrackController();
        }
        return instance;
    }

    private TrackController() {
        Authenticator.setDefault(new SavantHTTPAuthenticator());
    }

    public synchronized List<Track> getTracks() {
        return this.tracks;
    }

    public Track getTrack(int index) {
        return this.tracks.get(index);
    }

    public void addTrack(Track t) {
        AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("track-event", "opened"), new NameValuePair("track-type", t.getClass().getSimpleName())});
        LOG.info((Object)("Added " + t + " to track list."));
        this.tracks.add(t);
        this.fireEvent(new TrackEvent(TrackEvent.Type.ADDED, t));
    }

    public List<Track> getTracks(DataFormat kind) {
        ArrayList<Track> tracksOfKind = new ArrayList<Track>();
        for (Track t : this.tracks) {
            if (t.getDataFormat() != kind) continue;
            tracksOfKind.add(t);
        }
        return tracksOfKind;
    }

    public void removeTrack(Track t) {
        this.tracks.remove(t);
        this.fireEvent(new TrackEvent(TrackEvent.Type.REMOVED, t));
    }

    public Track getTrack(String tname) {
        for (Track t : this.tracks) {
            if (!t.getName().equals(tname)) continue;
            return t;
        }
        return null;
    }

    public void closeTracks() {
        FrameController.getInstance().closeAllFrames(false);
    }

    public void removeUnframedTrack(Track t) {
        this.tracks.remove(t);
    }

    public boolean containsTrack(String name) {
        for (Track t : this.tracks) {
            if (!name.equals(t.getName())) continue;
            return true;
        }
        return false;
    }
}

