/*
 * Decompiled with CFR 0.152.
 */
package savant.data.sources;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.SeekableStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.BAMDataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.data.DataFormat;
import savant.api.util.Resolution;
import savant.controller.LocationController;
import savant.data.sources.DataSource;
import savant.data.types.BAMIntervalRecord;
import savant.util.IndexCache;
import savant.util.MiscUtils;
import savant.util.NetworkUtils;

public class BAMDataSource
extends DataSource<BAMIntervalRecord>
implements BAMDataSourceAdapter {
    private static final Log LOG = LogFactory.getLog(BAMDataSource.class);
    private SAMFileReader samFileReader;
    private SAMFileHeader samFileHeader;
    private URI uri;
    Set<String> referenceNames;

    public BAMDataSource(URI uri) throws IOException {
        this.uri = uri.normalize();
        File indexFile = IndexCache.getIndexFile(uri, "bai", "bam");
        SeekableStream stream = NetworkUtils.getSeekableStreamForURI(uri);
        this.samFileReader = new SAMFileReader(stream, indexFile, false);
        this.samFileReader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        this.samFileHeader = this.samFileReader.getFileHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BAMIntervalRecord> getRecords(String reference, RangeAdapter range, Resolution resolution, RecordFilterAdapter filt) throws InterruptedException {
        SAMRecordIterator recordIterator = null;
        ArrayList<BAMIntervalRecord> result = new ArrayList<BAMIntervalRecord>();
        try {
            String ref = this.getReferenceNames().contains(reference) ? reference : (this.getReferenceNames().contains(MiscUtils.homogenizeSequence(reference)) ? MiscUtils.homogenizeSequence(reference) : this.guessSequence());
            recordIterator = this.samFileReader.query(ref, range.getFrom(), range.getTo(), false);
            while (recordIterator.hasNext()) {
                SAMRecord samRecord = (SAMRecord)recordIterator.next();
                if (samRecord.getReadUnmappedFlag()) continue;
                BAMIntervalRecord record = BAMIntervalRecord.valueOf(samRecord);
                if (filt == null || filt.accept(record)) {
                    result.add(record);
                }
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            if (recordIterator != null) {
                recordIterator.close();
            }
        }
        return result;
    }

    private String guessSequence() {
        LocationController locationController = LocationController.getInstance();
        int referenceSequenceLength = locationController.getMaxRangeEnd() - locationController.getMaxRangeStart();
        assert (Math.abs(referenceSequenceLength) < Integer.MAX_VALUE);
        String sequenceName = null;
        SAMSequenceDictionary sequenceDictionary = this.samFileHeader.getSequenceDictionary();
        int leastDifferenceInSequenceLength = Integer.MAX_VALUE;
        int closestSequenceIndex = Integer.MAX_VALUE;
        int i = 0;
        for (SAMSequenceRecord sequenceRecord : sequenceDictionary.getSequences()) {
            int lengthDelta = Math.abs(sequenceRecord.getSequenceLength() - referenceSequenceLength);
            if (lengthDelta < leastDifferenceInSequenceLength) {
                leastDifferenceInSequenceLength = lengthDelta;
                closestSequenceIndex = i;
            }
            ++i;
        }
        if (closestSequenceIndex != Integer.MAX_VALUE) {
            sequenceName = sequenceDictionary.getSequence(closestSequenceIndex).getSequenceName();
        }
        return sequenceName;
    }

    @Override
    public void close() {
        if (this.samFileReader != null) {
            this.samFileReader.close();
        }
    }

    @Override
    public Set<String> getReferenceNames() {
        if (this.referenceNames == null) {
            SAMSequenceDictionary ssd = this.samFileHeader.getSequenceDictionary();
            List seqs = ssd.getSequences();
            this.referenceNames = new HashSet<String>();
            for (SAMSequenceRecord ssr : seqs) {
                this.referenceNames.add(ssr.getSequenceName());
            }
        }
        return this.referenceNames;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public final DataFormat getDataFormat() {
        return DataFormat.ALIGNMENT;
    }

    @Override
    public final String[] getColumnNames() {
        return new String[]{"Read Name", "Sequence", "Length", "First of Pair", "Position", "Strand +", "Mapping Quality", "Base Qualities", "CIGAR", "Mate Position", "Strand +", "Inferred Insert Size"};
    }

    @Override
    public SAMFileHeader getHeader() {
        return this.samFileHeader;
    }
}

