/*
 * Decompiled with CFR 0.152.
 */
package savant.data.sources;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broad.igv.tdf.TDFDataset;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.track.WindowFunction;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.data.DataFormat;
import savant.api.util.Resolution;
import savant.controller.LocationController;
import savant.data.sources.DataSource;
import savant.data.types.GenericContinuousRecord;
import savant.util.MiscUtils;
import savant.util.Range;

public class TDFDataSource
extends DataSource<GenericContinuousRecord> {
    private static final Log LOG = LogFactory.getLog(TDFDataSource.class);
    private static final double LOG2 = Math.log(2.0);
    private static final int NOTIONAL_SCREEN_WIDTH = 2000;
    private final TDFReader tdf;
    private final URI uri;
    private int maxZoom = -1;
    private String rawUnhomogenised;

    public TDFDataSource(URI uri) throws IOException {
        this.tdf = TDFReader.getReader(uri);
        this.uri = uri;
    }

    @Override
    public Set<String> getReferenceNames() {
        HashSet<String> result = new HashSet<String>();
        for (String key : this.tdf.getDatasetNames()) {
            int rawPos = key.indexOf("/raw");
            if (rawPos <= 1) continue;
            result.add(key.substring(1, rawPos));
        }
        return result;
    }

    public List<GenericContinuousRecord> getRecords(String ref, RangeAdapter r, Resolution res, RecordFilterAdapter filt) throws IOException, InterruptedException {
        ArrayList<GenericContinuousRecord> result = new ArrayList<GenericContinuousRecord>();
        TDFDataset ds = this.getTDFDataset(ref, (Range)r);
        if (ds != null) {
            int nextPos = r.getFrom();
            int rangeEnd = r.getTo() + 1;
            int usefulStep = Math.max(1, r.getLength() / 2000);
            List<TDFTile> tiles = ds.getTiles(r.getFrom(), rangeEnd);
            for (TDFTile t : tiles) {
                for (int i = 0; i < t.getSize() && nextPos <= rangeEnd; ++i) {
                    int datumEnd = t.getEndPosition(i);
                    if (nextPos >= datumEnd) continue;
                    int datumStart = t.getStartPosition(i);
                    if (datumStart == nextPos + 1 && usefulStep > 2) {
                        LOG.debug((Object)("Skipping NaN hole at " + nextPos));
                    } else {
                        while (nextPos < datumStart && nextPos <= rangeEnd) {
                            result.add(GenericContinuousRecord.valueOf(ref, nextPos, Float.NaN));
                            nextPos += usefulStep;
                        }
                    }
                    float datum = t.getValue(0, i);
                    LOG.debug((Object)("Tile " + i + " from " + datumStart + " to " + datumEnd + "=" + datum));
                    while (nextPos < datumEnd && nextPos <= rangeEnd) {
                        result.add(GenericContinuousRecord.valueOf(ref, nextPos, datum));
                        nextPos += usefulStep;
                    }
                }
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
        }
        return result;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public void close() {
        this.tdf.close();
    }

    private TDFDataset getTDFDataset(String ref, Range r) {
        int refLen = LocationController.getInstance().getReferenceLength(ref);
        ref = MiscUtils.homogenizeSequence(ref);
        int rangeLen = r.getLength();
        if (this.maxZoom < 0) {
            Collection<String> dsNames = this.tdf.getDatasetNames();
            for (String dsName : dsNames) {
                String[] split = dsName.split("/");
                if (split.length == 4 && MiscUtils.homogenizeSequence(split[1]).equals(ref) && split[2].startsWith("z") && split[3].equals("mean")) {
                    int zoom = Integer.valueOf(split[2].substring(1));
                    if (zoom <= this.maxZoom) continue;
                    this.maxZoom = zoom;
                    continue;
                }
                if (split.length != 3 || !MiscUtils.homogenizeSequence(split[1]).equals(ref) || !split[2].equals("raw")) continue;
                this.rawUnhomogenised = dsName;
            }
        }
        TDFDataset result = null;
        int zoom = (int)(Math.log(refLen / rangeLen) / LOG2);
        if (zoom <= this.maxZoom) {
            LOG.info((Object)("Using zoomed dataset " + zoom));
            result = this.tdf.getDataset(ref, zoom, WindowFunction.mean);
            if (result == null) {
                result = this.tdf.getDataset("chr" + ref, zoom, WindowFunction.mean);
            }
        }
        if (result == null) {
            result = this.tdf.getDataset(this.rawUnhomogenised);
        }
        return result;
    }

    @Override
    public DataFormat getDataFormat() {
        return DataFormat.CONTINUOUS;
    }

    @Override
    public final String[] getColumnNames() {
        return GenericContinuousRecord.COLUMN_NAMES;
    }
}

