/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import savant.api.adapter.RangeAdapter;
import savant.api.data.Block;
import savant.data.types.TabixRichIntervalRecord;
import savant.util.ColumnMapping;
import savant.util.Range;

public class GFFIntervalRecord
extends TabixRichIntervalRecord {
    protected static final int FEATURE_COLUMN = 2;
    public static final int ATTRIBUTE_COLUMN = 8;
    protected String name;
    protected String name2;
    private List<Block> blocks;
    private int thickStart = -1;
    private int thickEnd = -1;

    GFFIntervalRecord(String line) {
        super(line, ColumnMapping.GFF);
        this.name = this.extractGFF3Attribute("Name");
        if (this.name != null) {
            this.name2 = this.extractGFF3Attribute("Alias");
        }
    }

    protected GFFIntervalRecord(String line, ColumnMapping mapping) {
        super(line, mapping);
    }

    @Override
    public final List<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlternateName() {
        return this.name2;
    }

    @Override
    public int getThickStart() {
        return this.thickStart >= 0 ? this.thickStart : this.interval.getStart();
    }

    @Override
    public int getThickEnd() {
        return this.thickEnd >= 0 ? this.thickEnd : this.interval.getEnd();
    }

    public String getFeatureType() {
        return this.values[2];
    }

    public boolean absorbRecord(GFFIntervalRecord child) {
        if (this.isParentOf(child)) {
            String childType = child.getFeatureType();
            if (childType.equals("exon")) {
                if (this.values[2].equals("transcript") || this.values[2].equals("mRNA")) {
                    if (this.blocks == null) {
                        this.blocks = new ArrayList<Block>();
                    }
                    this.blocks.add(Block.valueOf(child.interval.getStart() - this.interval.getStart(), child.interval.getLength()));
                    return true;
                }
            } else {
                if (childType.equals("CDS")) {
                    if (this.thickStart < 0) {
                        this.thickStart = child.interval.getStart();
                    }
                    this.thickEnd = Math.max(this.thickEnd, child.interval.getEnd());
                    return true;
                }
                if (childType.equals("intron")) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public RangeAdapter getExpandedRange(RangeAdapter r) {
        if ((this.values[2].equals("transcript") || this.values[2].equals("mRNA")) && (this.interval.getStart() < r.getFrom() || this.interval.getEnd() > r.getTo())) {
            return new Range(Math.min(this.interval.getStart(), r.getFrom()), Math.max(this.interval.getEnd(), r.getTo()));
        }
        return null;
    }

    protected boolean isParentOf(GFFIntervalRecord child) {
        String id;
        String parent;
        return this.name != null && (parent = child.extractGFF3Attribute("Parent")) != null && parent.equals(id = this.extractGFF3Attribute("ID"));
    }

    private String extractGFF3Attribute(String key) {
        key = key + '=';
        String attributes = this.values[8].trim();
        while (attributes.length() > 0) {
            int semiPos = attributes.indexOf(";");
            if (attributes.startsWith(key)) {
                int end = semiPos > 0 ? semiPos : attributes.length();
                return attributes.substring(key.length(), end);
            }
            if (semiPos <= 0) break;
            attributes = attributes.substring(semiPos + 1).trim();
        }
        return null;
    }

    public Map<String, String> getAttributes() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String[] attributes = this.values[8].trim().split(";");
        if (attributes.length == 1 && attributes[0].indexOf(59) < 0) {
            result.put("Group", attributes[0]);
        } else {
            for (String s : attributes) {
                int equalPos = s.indexOf(61);
                if (equalPos <= 0) continue;
                result.put(s.substring(0, equalPos), s.substring(equalPos + 1));
            }
        }
        return result;
    }
}

