/*
 * Decompiled with CFR 0.152.
 */
package savant.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.data.DataFormat;
import savant.api.event.GenomeChangedEvent;
import savant.api.util.Listener;
import savant.controller.BookmarkController;
import savant.controller.FrameController;
import savant.controller.GenomeController;
import savant.controller.LocationController;
import savant.data.types.Genome;
import savant.exception.SavantEmptySessionException;
import savant.util.Bookmark;
import savant.util.DrawingMode;
import savant.util.NetworkUtils;
import savant.util.Range;
import savant.view.swing.Frame;
import savant.view.tracks.Track;
import savant.view.variation.VariationController;

public class Project {
    private static final Log LOG = LogFactory.getLog(Project.class);
    private static final int FILE_VERSION = 2;
    private Genome genome;
    private List<Bookmark> bookmarks;
    private List<String> trackPaths;
    private List<DrawingMode> trackModes;
    private List<String> controls;
    private String reference;
    private Range range;
    private String genomePath;
    private static XMLStreamWriter writer;
    private static XMLStreamReader reader;

    public Project(File f) throws Exception {
        try {
            this.createFromSerialization(new FileInputStream(f));
        }
        catch (StreamCorruptedException x) {
            try {
                this.createFromXML(new GZIPInputStream(new FileInputStream(f)));
            }
            catch (IOException x2) {
                this.createFromXML(new FileInputStream(f));
            }
        }
    }

    public Project(Genome genome, URI[] trackURIs) {
        this.reference = genome.getReferenceNames().iterator().next();
        this.range = new Range(1, 1000);
        this.genome = genome;
        this.trackPaths = new ArrayList<String>(trackURIs.length);
        for (URI u : trackURIs) {
            this.trackPaths.add(u.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromSerialization(InputStream input) throws ClassNotFoundException, IOException {
        ObjectInputStream objectStream = null;
        try {
            objectStream = new ObjectInputStream(input);
            try {
                String key;
                while ((key = (String)objectStream.readObject()) != null) {
                    Object value = objectStream.readObject();
                    if (key.equals("GENOME")) {
                        this.genome = (Genome)value;
                        continue;
                    }
                    if (key.equals("BOOKMARKS")) {
                        this.bookmarks = (List)value;
                        continue;
                    }
                    if (key.equals("TRACKS")) {
                        this.trackPaths = (List)value;
                        continue;
                    }
                    if (key.equals("REFERENCE")) {
                        this.reference = (String)value;
                        continue;
                    }
                    if (!key.equals("RANGE")) continue;
                    this.range = (Range)value;
                }
            }
            catch (EOFException e) {
                // empty catch block
            }
        }
        finally {
            try {
                objectStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private void createFromXML(InputStream input) throws XMLStreamException, ParseException, IOException {
        this.trackPaths = new ArrayList<String>();
        this.trackModes = new ArrayList<DrawingMode>();
        this.bookmarks = new ArrayList<Bookmark>();
        this.controls = new ArrayList<String>();
        String genomeName = null;
        String genomeDesc = null;
        String cytobandPath = null;
        ArrayList<Genome.ReferenceInfo> references = new ArrayList<Genome.ReferenceInfo>();
        reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
        int version = -1;
        boolean done = false;
        block14: do {
            switch (reader.next()) {
                case 1: {
                    switch (Project.readElement()) {
                        case savant: {
                            version = Integer.valueOf(Project.readAttribute(XMLAttribute.version));
                            Bookmark r = new Bookmark(Project.readAttribute(XMLAttribute.range));
                            this.range = (Range)r.getRange();
                            this.reference = r.getReference();
                            LOG.info((Object)("Reading project version " + version));
                            break;
                        }
                        case genome: {
                            genomeName = Project.readAttribute(XMLAttribute.name);
                            genomeDesc = Project.readAttribute(XMLAttribute.description);
                            this.genomePath = Project.readAttribute(XMLAttribute.uri);
                            cytobandPath = Project.readAttribute(XMLAttribute.cytoband);
                            break;
                        }
                        case reference: {
                            references.add(new Genome.ReferenceInfo(Project.readAttribute(XMLAttribute.name), Integer.valueOf(Project.readAttribute(XMLAttribute.length))));
                            break;
                        }
                        case track: {
                            this.trackPaths.add(Project.readAttribute(XMLAttribute.uri));
                            try {
                                this.trackModes.add(DrawingMode.valueOf(Project.readAttribute(XMLAttribute.mode)));
                            }
                            catch (Exception x) {
                                this.trackModes.add(null);
                            }
                            break;
                        }
                        case bookmark: {
                            Bookmark b = new Bookmark(Project.readAttribute(XMLAttribute.range));
                            b.setAnnotation(reader.getElementText());
                            this.bookmarks.add(b);
                            break;
                        }
                        case control: {
                            this.controls.add(reader.getElementText());
                        }
                    }
                    continue block14;
                }
                case 8: {
                    reader.close();
                    done = true;
                }
            }
        } while (!done);
        if (cytobandPath != null) {
            this.genome = new Genome(genomeName, genomeDesc, URI.create(cytobandPath), null);
        } else if (references.size() > 0) {
            this.genome = new Genome(genomeName, genomeDesc, references.toArray(new Genome.ReferenceInfo[0]));
        }
    }

    private static XMLElement readElement() {
        String elemName = reader.getLocalName();
        return Enum.valueOf(XMLElement.class, elemName);
    }

    private static String readAttribute(XMLAttribute attr) {
        return reader.getAttributeValue(null, attr.toString());
    }

    public static void saveToFile(File f) throws IOException, SavantEmptySessionException, XMLStreamException {
        GZIPOutputStream output = new GZIPOutputStream(new FileOutputStream(f));
        writer = XMLOutputFactory.newInstance().createXMLStreamWriter(output, "UTF-8");
        writer.writeStartDocument();
        Project.writeStartElement(XMLElement.savant, "");
        Project.writeAttribute(XMLAttribute.version, Integer.toString(2));
        LocationController locationController = LocationController.getInstance();
        Range r = locationController.getRange();
        Project.writeAttribute(XMLAttribute.range, String.format("%s:%d-%d", locationController.getReferenceName(), r.getFrom(), r.getTo()));
        Project.writeStartElement(XMLElement.genome, "  ");
        Genome g = GenomeController.getInstance().getGenome();
        Project.writeAttribute(XMLAttribute.name, g.getName());
        URI cytobandURI = g.getCytobandURI();
        if (cytobandURI != null) {
            Project.writeAttribute(XMLAttribute.cytoband, cytobandURI.toString());
        }
        if (g.isSequenceSet()) {
            Project.writeAttribute(XMLAttribute.uri, NetworkUtils.getNeatPathFromURI(g.getDataSource().getURI()));
        } else {
            for (String ref : g.getReferenceNames()) {
                Project.writeEmptyElement(XMLElement.reference, "    ");
                Project.writeAttribute(XMLAttribute.name, ref);
                Project.writeAttribute(XMLAttribute.length, Integer.toString(g.getLength(ref)));
            }
        }
        writer.writeCharacters("\r\n  ");
        writer.writeEndElement();
        for (Frame fr : FrameController.getInstance().getOrderedFrames()) {
            Track t0;
            URI uri;
            Track[] tracks = fr.getTracks();
            if (tracks.length <= 0 || (uri = (t0 = tracks[0]).getDataSource().getURI()) == null) continue;
            Project.writeEmptyElement(XMLElement.track, "  ");
            Project.writeAttribute(XMLAttribute.uri, NetworkUtils.getNeatPathFromURI(uri));
            Project.writeAttribute(XMLAttribute.mode, t0.getDrawingMode().toString());
        }
        for (Bookmark b : BookmarkController.getInstance().getBookmarks()) {
            Project.writeStartElement(XMLElement.bookmark, "  ");
            Project.writeAttribute(XMLAttribute.range, b.getLocationText());
            writer.writeCharacters(b.getAnnotation());
            writer.writeEndElement();
        }
        for (String p : VariationController.getInstance().getControls()) {
            Project.writeStartElement(XMLElement.control, "   ");
            writer.writeCharacters(p);
            writer.writeEndElement();
        }
        writer.writeCharacters("\r\n");
        writer.writeEndElement();
        writer.writeEndDocument();
        output.finish();
        writer.close();
    }

    private static void writeEmptyElement(XMLElement elem, String indent) throws XMLStreamException {
        writer.writeCharacters("\r\n" + indent);
        writer.writeEmptyElement(elem.toString());
    }

    private static void writeStartElement(XMLElement elem, String indent) throws XMLStreamException {
        writer.writeCharacters("\r\n" + indent);
        writer.writeStartElement(elem.toString());
    }

    private static void writeAttribute(XMLAttribute attr, String value) throws XMLStreamException {
        writer.writeAttribute(attr.toString(), value);
    }

    public List<String> getInitialTracks() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.trackPaths);
        return result;
    }

    public void load() throws Exception {
        GenomeController genomeController = GenomeController.getInstance();
        genomeController.setGenome(this.genome);
        LocationController.getInstance().setLocation(this.reference, this.range);
        if (this.genome == null) {
            genomeController.addListener(new Listener<GenomeChangedEvent>(){

                @Override
                public void handleEvent(GenomeChangedEvent event) {
                    GenomeController.getInstance().removeListener(this);
                    LOG.info((Object)"Received genomeChanged");
                    for (int i = 0; i < Project.this.trackPaths.size(); ++i) {
                        String path = (String)Project.this.trackPaths.get(i);
                        DrawingMode mode = (DrawingMode)((Object)Project.this.trackModes.get(i));
                        if (path.equals(Project.this.genomePath)) continue;
                        LOG.info((Object)("Adding ordinary track for " + path));
                        FrameController.getInstance().addTrackFromPath(path, null, mode);
                    }
                }
            });
            LOG.info((Object)("Adding sequence track for " + this.genomePath));
            FrameController.getInstance().addTrackFromPath(this.genomePath, DataFormat.SEQUENCE, null);
        } else {
            for (int i = 0; i < this.trackPaths.size(); ++i) {
                String path = this.trackPaths.get(i);
                DrawingMode mode = this.trackModes != null ? this.trackModes.get(i) : null;
                FrameController.getInstance().addTrackFromPath(path, null, mode);
            }
        }
        if (this.bookmarks != null && this.bookmarks.size() > 0) {
            BookmarkController.getInstance().addBookmarks(this.bookmarks);
        }
        if (this.controls != null) {
            VariationController.getInstance().setControls(this.controls);
        }
    }

    private static enum XMLAttribute {
        version,
        name,
        description,
        uri,
        range,
        length,
        cytoband,
        mode;

    }

    private static enum XMLElement {
        savant,
        genome,
        reference,
        track,
        bookmark,
        control;

    }
}

