/*
 * Decompiled with CFR 0.152.
 */
package savant.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.samtools.util.SeekableBufferedStream;
import net.sf.samtools.util.SeekableFileStream;
import net.sf.samtools.util.SeekableStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.file.FieldType;
import savant.file.FileType;
import savant.file.FileTypeHeader;
import savant.file.ROFile;
import savant.file.SavantFileNotFormattedException;
import savant.file.SavantUnsupportedVersionException;
import savant.util.MiscUtils;
import savant.util.NetworkUtils;
import savant.util.SavantFileUtils;

public class SavantROFile
implements ROFile {
    private static final Log LOG = LogFactory.getLog(SavantROFile.class);
    private final SeekableStream seekStream;
    private FileTypeHeader fileTypeHeader;
    private Map<String, long[]> referenceMap;
    private List<FieldType> fields;
    private long headerOffset;
    private URI uri;
    private byte[] oneByteBuf = new byte[1];
    private long filePointer = 0L;
    public static final int CURRENT_FILE_VERSION = 2;
    public static final List<Integer> SUPPORTED_FILE_VERSIONS = Arrays.asList(2);

    public SavantROFile(File file) throws IOException, SavantFileNotFormattedException {
        this.uri = file.toURI();
        LOG.debug((Object)("Adding RO File: " + file));
        LOG.debug((Object)("URI is: " + this.uri));
        this.seekStream = new SeekableBufferedStream((SeekableStream)new SeekableFileStream(file));
        this.init();
    }

    public SavantROFile(File file, FileType ft) throws IOException, SavantFileNotFormattedException {
        this(file);
        if (!(this.fileTypeHeader.fileType.equals((Object)ft) || this.fileTypeHeader.fileType == FileType.INTERVAL_GFF && ft == FileType.INTERVAL_GENERIC)) {
            throw new IOException("Wrong file type");
        }
    }

    public SavantROFile(URI uri) throws IOException, SavantFileNotFormattedException {
        this.uri = uri.normalize();
        this.seekStream = NetworkUtils.getSeekableStreamForURI(uri);
        this.init();
    }

    public SavantROFile(URI uri, FileType ft) throws IOException, SavantFileNotFormattedException {
        this(uri);
        if (!this.fileTypeHeader.fileType.equals((Object)ft)) {
            if (this.fileTypeHeader.fileType == FileType.INTERVAL_GFF && ft == FileType.INTERVAL_GENERIC) {
                return;
            }
            throw new IOException("Wrong file type");
        }
    }

    private void init() throws IOException, SavantFileNotFormattedException {
        LOG.debug((Object)"Reading file type");
        this.fileTypeHeader = SavantFileUtils.readFileTypeHeader(this);
        if (this.fileTypeHeader.fileType == null) {
            throw new SavantFileNotFormattedException("This file does not appear to be formatted. Format now?");
        }
        if (!this.isSupportedVersion(this.fileTypeHeader.version)) {
            throw new SavantUnsupportedVersionException(this.fileTypeHeader.version, this.getSupportedVersions());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("File type: " + (Object)((Object)this.fileTypeHeader.fileType)));
            LOG.debug((Object)("Done... at " + this.getFilePointer() + " bytes"));
            LOG.debug((Object)"Reading fields");
        }
        this.fields = SavantFileUtils.readFieldsHeader(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.fields);
            LOG.debug((Object)("Number of fields: " + this.fields.size()));
            LOG.debug((Object)"Reading reference<-> data map");
        }
        this.referenceMap = SavantFileUtils.readReferenceMap(this);
        if (LOG.isDebugEnabled()) {
            for (String refname : this.referenceMap.keySet()) {
                long[] vals = this.referenceMap.get(refname);
                LOG.debug((Object)("Reference " + refname + " at " + vals[0] + " of length " + vals[1]));
            }
        }
        LOG.debug((Object)("Making note of offset: " + this.getFilePointer()));
        this.headerOffset = this.getFilePointer();
    }

    @Override
    public synchronized long seek(String reference, long pos) throws IOException {
        if (!this.containsDataForReference(reference) && !this.containsDataForReference(MiscUtils.homogenizeSequence(reference))) {
            LOG.debug((Object)("No data for reference: " + reference));
            return -1L;
        }
        if (pos >= this.getReferenceLength(reference) && pos >= this.getReferenceLength(reference.substring(reference.length() - 1))) {
            LOG.debug((Object)("End of data for reference: " + reference));
            return -1L;
        }
        long refoffset = this.getReferenceOffset(reference);
        if (refoffset == -1L) {
            refoffset = this.getReferenceOffset(MiscUtils.homogenizeSequence(reference));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Seeking to " + (pos + refoffset + this.headerOffset) + " pos=" + pos + " ref=" + reference + " refoffset=" + refoffset + " headeroffset=" + this.headerOffset + " file=" + this.uri.toString()));
        }
        this.seek(pos + refoffset + this.headerOffset);
        return pos + refoffset + this.headerOffset;
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        if (this.filePointer != pos) {
            this.seekStream.seek(pos);
            this.filePointer = pos;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Seeking to " + pos));
                LOG.debug((Object)"warning: consider calling seek (string reference, long pos) instead");
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.seekStream.close();
    }

    @Override
    public synchronized long getFilePointer() throws IOException {
        return this.filePointer;
    }

    @Override
    public synchronized long length() throws IOException {
        return this.seekStream.length();
    }

    @Override
    public synchronized int read() throws IOException {
        int bytesRead = this.seekStream.read(this.oneByteBuf, 0, 1);
        if (bytesRead != -1) {
            byte result = this.oneByteBuf[0];
            ++this.filePointer;
            return result;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        int result = this.seekStream.read(b, 0, b.length);
        if (result != -1) {
            this.filePointer += (long)result;
        }
        return result;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int result = this.seekStream.read(b, off, len);
        if (result != -1) {
            this.filePointer += (long)result;
        }
        return result;
    }

    @Override
    public synchronized byte readByte() throws IOException {
        byte result = (byte)(this.read() & 0xFF);
        return result;
    }

    @Override
    public synchronized double readDouble() throws IOException {
        byte[] bytes = new byte[8];
        int result = this.read(bytes);
        if (result != 8) {
            LOG.warn((Object)"Could not read 8 bytes for a double");
            throw new IOException("At EOF");
        }
        long longBits = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
        return Double.longBitsToDouble(longBits);
    }

    @Override
    public synchronized float readFloat() throws IOException {
        byte[] bytes = new byte[4];
        int result = this.read(bytes);
        if (result != 4) {
            LOG.warn((Object)"Could not read 4 bytes for float");
            throw new IOException("At EOF");
        }
        int intBits = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        return Float.intBitsToFloat(intBits);
    }

    @Override
    public synchronized int readInt() throws IOException {
        byte[] bytes = new byte[4];
        int result = this.read(bytes);
        if (result != 4) {
            LOG.warn((Object)"Could not read 4 bytes for int");
            throw new IOException("At EOF");
        }
        int intBits = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        return intBits;
    }

    @Override
    public synchronized String readLine() throws IOException {
        byte[] readBytes = new byte[2];
        StringBuilder sb = new StringBuilder();
        while (true) {
            int read;
            if ((read = this.read(readBytes)) != 2) {
                LOG.warn((Object)"Unable to read 2 bytes");
                return sb.toString();
            }
            char theChar = (char)(readBytes[0] << 8 | readBytes[1]);
            if (theChar == '\r') {
                theChar = (char)(readBytes[0] << 8 | readBytes[1]);
            }
            if (theChar == '\n') {
                return sb.toString();
            }
            sb.append(theChar);
        }
    }

    @Override
    public synchronized long readLong() throws IOException {
        byte[] bytes = new byte[8];
        int result = this.read(bytes);
        if (result != 8) {
            LOG.warn((Object)"Could not read 8 bytes for a long");
            throw new IOException("At EOF");
        }
        long longBits = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
        return longBits;
    }

    @Override
    public List<FieldType> getFields() {
        return this.fields;
    }

    @Override
    public Map<String, long[]> getReferenceMap() {
        return this.referenceMap;
    }

    @Override
    public long getHeaderOffset() {
        return this.headerOffset;
    }

    @Override
    public void setHeaderOffset(long offset) {
        this.headerOffset = offset;
    }

    public boolean isSupportedVersion(int version) {
        return SUPPORTED_FILE_VERSIONS.contains(version);
    }

    public String getSupportedVersions() {
        StringBuilder sb = new StringBuilder();
        for (Integer version : SUPPORTED_FILE_VERSIONS) {
            sb.append(version).append(" ");
        }
        return sb.toString().trim();
    }

    public long getReferenceOffset(String reference) {
        if (!this.containsDataForReference(reference)) {
            return -1L;
        }
        return this.referenceMap.get(reference)[0];
    }

    public long getReferenceLength(String reference) {
        if (!this.containsDataForReference(reference)) {
            return -1L;
        }
        return this.referenceMap.get(reference)[1];
    }

    public boolean containsDataForReference(String reference) {
        return this.referenceMap.containsKey(reference);
    }

    public FileType getFileType() {
        return this.fileTypeHeader.fileType;
    }

    public URI getURI() {
        LOG.debug((Object)("Getting URI: " + this.uri));
        return this.uri;
    }
}

