/*
 * Decompiled with CFR 0.152.
 */
package savant.plugin;

import com.apple.eio.FileManager;
import java.awt.BorderLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.event.PluginEvent;
import savant.api.util.DialogUtils;
import savant.controller.DataSourcePluginController;
import savant.plugin.PluginDescriptor;
import savant.plugin.PluginIndex;
import savant.plugin.PluginVersionException;
import savant.plugin.SavantDataSourcePlugin;
import savant.plugin.SavantPanelPlugin;
import savant.plugin.SavantPlugin;
import savant.settings.BrowserSettings;
import savant.settings.DirectorySettings;
import savant.util.Controller;
import savant.util.IOUtils;
import savant.util.MiscUtils;
import savant.util.NetworkUtils;

public class PluginController
extends Controller {
    static final Log LOG = LogFactory.getLog(PluginController.class);
    private static final String UNINSTALL_FILENAME = ".uninstall_plugins";
    private static PluginController instance;
    private File uninstallFile;
    private List<String> pluginsToRemove = new ArrayList<String>();
    private Map<String, PluginDescriptor> knownPlugins = new HashMap<String, PluginDescriptor>();
    private Map<String, SavantPlugin> loadedPlugins = new HashMap<String, SavantPlugin>();
    private Map<String, String> pluginErrors = new LinkedHashMap<String, String>();
    private PluginLoader pluginLoader;
    private PluginIndex repositoryIndex = null;

    public static synchronized PluginController getInstance() {
        if (instance == null) {
            instance = new PluginController();
        }
        return instance;
    }

    private PluginController() {
        try {
            this.uninstallFile = new File(DirectorySettings.getSavantDirectory(), UNINSTALL_FILENAME);
            LOG.info((Object)"Uninstall list .uninstall_plugins");
            if (this.uninstallFile.exists()) {
                this.deleteFileList(this.uninstallFile);
            }
            this.copyBuiltInPlugins();
        }
        catch (Exception ex) {
            LOG.error((Object)"Error loading plugins.", (Throwable)ex);
        }
    }

    public void loadPlugins(File pluginsDir) {
        File[] files;
        for (File f : files = pluginsDir.listFiles(new PluginFileFilter())) {
            try {
                this.addPlugin(f);
            }
            catch (PluginVersionException x) {
                LOG.warn((Object)("No compatible plugins found in " + f));
            }
        }
        if (this.pluginErrors.size() > 0) {
            ArrayList<String> updated = new ArrayList<String>();
            for (String s : this.pluginErrors.keySet()) {
                if (!this.checkForPluginUpdate(s)) continue;
                updated.add(s);
            }
            if (updated.size() > 0) {
                DialogUtils.displayMessage("Plugins Updated", String.format("<html>The following plugins were updated to be compatible with Savant %s:<br><br><i>%s</i></html>", "2.0.4", StringUtils.join(updated, (String)", ")));
                for (String s : updated) {
                    this.pluginErrors.remove(s);
                }
            }
            if (this.pluginErrors.size() > 0) {
                StringBuilder errorStr = null;
                for (String s : this.pluginErrors.keySet()) {
                    if (errorStr == null) {
                        errorStr = new StringBuilder();
                    } else {
                        errorStr.append("<br>");
                    }
                    errorStr.append(s);
                    errorStr.append(" \u2013 ");
                    errorStr.append(this.pluginErrors.get(s));
                }
                if (errorStr != null) {
                    DialogUtils.displayMessage("Plugins Not Loaded", String.format("<html>The following plugins could not be loaded:<br><br><i>%s</i><br><br>They will not be available to Savant.</html>", errorStr));
                }
            }
        }
        HashSet<URL> jarURLs = new HashSet<URL>();
        for (PluginDescriptor desc : this.knownPlugins.values()) {
            try {
                if (this.pluginErrors.containsKey(desc.getID())) continue;
                jarURLs.addAll(Arrays.asList(desc.getJars()));
            }
            catch (Exception x) {
                LOG.warn((Object)"Error while accumulating URLs for plugin JARs.", (Throwable)x);
            }
        }
        if (jarURLs.size() > 0) {
            this.pluginLoader = new PluginLoader(jarURLs.toArray(new URL[0]), this.getClass().getClassLoader());
            PluginDescriptor dataDesc = this.knownPlugins.get("savant.data");
            if (dataDesc != null && !this.pluginErrors.containsKey("savant.data")) {
                new LoaderThread(dataDesc).run();
            }
            for (PluginDescriptor desc : this.knownPlugins.values()) {
                if (desc == dataDesc || this.pluginErrors.containsKey(desc.getID())) continue;
                new LoaderThread(desc).start();
            }
        }
    }

    public List<PluginDescriptor> getDescriptors() {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        result.addAll(this.knownPlugins.values());
        Collections.sort(result);
        return result;
    }

    public SavantPlugin getPlugin(String id) {
        return this.loadedPlugins.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queuePluginForRemoval(String id) {
        OutputStreamWriter fstream = null;
        try {
            PluginDescriptor info = this.knownPlugins.get(id);
            LOG.info((Object)("Adding plugin " + info.getFile().getAbsolutePath() + " to uninstall list " + this.uninstallFile.getPath()));
            if (!this.uninstallFile.exists()) {
                this.uninstallFile.createNewFile();
            }
            fstream = new FileWriter(this.uninstallFile, true);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(info.getFile().getAbsolutePath() + "\n");
            out.close();
            DialogUtils.displayMessage("Uninstallation Complete", "Please restart Savant for changes to take effect.");
            this.pluginsToRemove.add(id);
            this.fireEvent(new PluginEvent(PluginEvent.Type.QUEUED_FOR_REMOVAL, id, null));
        }
        catch (IOException ex) {
            LOG.error((Object)("Error uninstalling plugin: " + this.uninstallFile), (Throwable)ex);
        }
        finally {
            try {
                fstream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isPluginQueuedForRemoval(String id) {
        return this.pluginsToRemove.contains(id);
    }

    public String getPluginStatus(String id) {
        if (this.pluginsToRemove.contains(id)) {
            return "Queued for removal";
        }
        if (this.loadedPlugins.get(id) != null) {
            return "Loaded";
        }
        String err = this.pluginErrors.get(id);
        if (err != null) {
            return err;
        }
        if (this.knownPlugins.get(id) != null) {
            return "Loading";
        }
        return "Unknown";
    }

    private JPanel initGUIPlugin(SavantPanelPlugin plugin) {
        JPanel canvas = new JPanel();
        canvas.setLayout(new BorderLayout());
        plugin.init(canvas);
        return canvas;
    }

    private void initSavantDataSourcePlugin(SavantDataSourcePlugin plugin) {
        DataSourcePluginController.getInstance().addDataSourcePlugin(plugin);
        plugin.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFileList(File fileListFile) {
        BufferedReader br = null;
        String line = "";
        try {
            br = new BufferedReader(new FileReader(fileListFile));
            while ((line = br.readLine()) != null) {
                LOG.info((Object)("Uninstalling " + line));
                if (new File(line).delete()) continue;
                throw new IOException("Delete of " + line + " failed");
            }
        }
        catch (IOException ex) {
            LOG.error((Object)("Problem uninstalling " + line), (Throwable)ex);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {}
        }
        fileListFile.delete();
    }

    private void copyBuiltInPlugins() {
        File destDir = DirectorySettings.getPluginsDirectory();
        File srcDir = null;
        PluginFileFilter pluginFilter = new PluginFileFilter();
        if (MiscUtils.MAC && (srcDir = new File(FileManager.getPathToApplicationBundle() + "/Contents/Plugins")).exists()) {
            try {
                IOUtils.copyDir(srcDir, destDir, pluginFilter);
                return;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        try {
            srcDir = new File("plugins");
            IOUtils.copyDir(srcDir, destDir, pluginFilter);
        }
        catch (Exception x) {
            LOG.error((Object)("Unable to copy builtin plugins from " + srcDir.getAbsolutePath() + " to " + destDir), (Throwable)x);
        }
    }

    private void loadPlugin(PluginDescriptor desc) throws Throwable {
        Class<?> pluginClass = this.pluginLoader.loadClass(desc.getClassName());
        SavantPlugin plugin = (SavantPlugin)pluginClass.newInstance();
        plugin.setDescriptor(desc);
        JPanel canvas = null;
        if (plugin instanceof SavantPanelPlugin) {
            canvas = this.initGUIPlugin((SavantPanelPlugin)plugin);
        } else if (plugin instanceof SavantDataSourcePlugin) {
            this.initSavantDataSourcePlugin((SavantDataSourcePlugin)plugin);
        }
        this.loadedPlugins.put(desc.getID(), plugin);
        this.fireEvent(new PluginEvent(PluginEvent.Type.LOADED, desc.getID(), canvas));
    }

    public PluginDescriptor addPlugin(File f) throws PluginVersionException {
        PluginDescriptor desc = PluginDescriptor.fromFile(f);
        if (desc != null) {
            LOG.info((Object)("Found usable " + desc + " in " + f.getName()));
            PluginDescriptor existingDesc = this.knownPlugins.get(desc.getID());
            if (existingDesc != null && existingDesc.getVersion().compareTo(desc.getVersion()) >= 0) {
                LOG.info((Object)("   Ignored " + desc + " due to presence of existing " + existingDesc));
                return null;
            }
            this.knownPlugins.put(desc.getID(), desc);
            if (desc.isCompatible()) {
                if (existingDesc != null) {
                    LOG.info((Object)("   Replaced " + existingDesc));
                    this.pluginErrors.remove(desc.getID());
                }
            } else {
                LOG.info((Object)("Found incompatible " + desc + " (SDK version " + desc.getSDKVersion() + ") in " + f.getName()));
                this.pluginErrors.put(desc.getID(), "Invalid SDK version (" + desc.getSDKVersion() + ")");
                throw new PluginVersionException("Invalid SDK version (" + desc.getSDKVersion() + ")");
            }
        }
        return desc;
    }

    public void installPlugin(File selectedFile) throws Throwable {
        File pluginFile = new File(DirectorySettings.getPluginsDirectory(), selectedFile.getName());
        IOUtils.copyFile(selectedFile, pluginFile);
        PluginDescriptor desc = this.addPlugin(pluginFile);
        if (desc != null) {
            desc.downloadExtras();
            if (this.pluginLoader == null) {
                this.pluginLoader = new PluginLoader(desc.getJars(), this.getClass().getClassLoader());
            } else {
                this.pluginLoader.addJars(desc.getJars());
            }
            this.loadPlugin(desc);
        }
    }

    private boolean checkForPluginUpdate(String id) {
        try {
            URL updateURL;
            if (this.repositoryIndex == null) {
                this.repositoryIndex = new PluginIndex(BrowserSettings.PLUGIN_URL);
            }
            if ((updateURL = this.repositoryIndex.getPluginURL(id)) != null) {
                String repoVersion = MiscUtils.getFilenameFromPath(updateURL.getFile());
                if ((repoVersion = repoVersion.substring(repoVersion.indexOf(45) + 1, repoVersion.lastIndexOf(46))).compareTo(this.knownPlugins.get((Object)id).version) > 0) {
                    LOG.info((Object)("Downloading updated version of " + id + " from " + updateURL));
                    this.addPlugin(NetworkUtils.downloadFile(updateURL, DirectorySettings.getPluginsDirectory(), null));
                    return true;
                }
                LOG.info((Object)("Repository version " + updateURL + " is no newer than local version of " + id + "."));
            }
        }
        catch (IOException x) {
            LOG.error((Object)("Unable to install update for " + id), (Throwable)x);
        }
        catch (PluginVersionException x) {
            LOG.error((Object)("Update for " + id + " not loaded."));
        }
        return false;
    }

    public void shutDown() {
        for (SavantPlugin p : this.loadedPlugins.values()) {
            try {
                p.shutDown();
            }
            catch (Throwable x) {
                LOG.warn((Object)("Error shutting down " + p.getTitle()), x);
            }
        }
    }

    class PluginFileFilter
    implements FilenameFilter {
        PluginFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return (name = name.toLowerCase()).endsWith(".jar") || name.endsWith(".xml");
        }
    }

    class PluginLoader
    extends URLClassLoader {
        PluginLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        void addJars(URL[] urls) {
            for (URL u : urls) {
                this.addURL(u);
            }
        }
    }

    class LoaderThread
    extends Thread {
        PluginDescriptor desc;

        LoaderThread(PluginDescriptor pd) {
            super("PluginLoader-" + pd);
            this.desc = pd;
        }

        @Override
        public void run() {
            try {
                PluginController.this.loadPlugin(this.desc);
            }
            catch (Throwable x) {
                LOG.error((Object)("Unable to load " + this.desc.getName()), x);
                PluginController.this.pluginErrors.put(this.desc.getID(), x.getClass().getName());
                DialogUtils.displayMessage("Plugin Not Loaded", String.format("<html>The following plugin could not be loaded:<br><br><i>%s \u2013 %s</i><br><br>It will not be available to Savant.</html>", this.desc.getID(), x));
            }
        }
    }
}

