/*
 * Decompiled with CFR 0.152.
 */
package savant.plugin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.util.NetworkUtils;

public class PluginIndex {
    private static final Log LOG = LogFactory.getLog(PluginIndex.class);
    private Map<String, URL> urls = new HashMap<String, URL>();

    public PluginIndex(URL url) throws IOException {
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(NetworkUtils.openStream(url));
            boolean done = false;
            String id = null;
            block8: do {
                switch (reader.next()) {
                    case 1: {
                        String elemName = reader.getLocalName();
                        if (elemName.equals("leaf")) {
                            id = reader.getAttributeValue(null, "id");
                            break;
                        }
                        if (!elemName.equals("url") || id == null) continue block8;
                        try {
                            this.urls.put(id, new URL(reader.getElementText()));
                        }
                        catch (MalformedURLException x) {
                            LOG.info((Object)("Unable to parse \"" + reader.getElementText() + "\" as a plugin URL."));
                        }
                        id = null;
                        break;
                    }
                    case 8: {
                        reader.close();
                        done = true;
                    }
                }
            } while (!done);
        }
        catch (XMLStreamException x) {
            throw new IOException("Unable to get version number from web-site.", x);
        }
    }

    public URL getPluginURL(String id) {
        return this.urls.get(id);
    }
}

