/*
 * Decompiled with CFR 0.152.
 */
package savant.plugin;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.samtools.SAMSequenceDictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.BAMDataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.api.util.TrackUtils;
import savant.controller.FrameController;
import savant.file.FileType;
import savant.format.SavantFileFormatter;
import savant.format.SavantFileFormatterUtils;
import savant.plugin.SavantPanelPlugin;
import savant.plugin.ToolArgument;
import savant.plugin.ToolSettingsPanel;
import savant.settings.DirectorySettings;
import savant.util.BackgroundWorker;
import savant.util.Bookmark;
import savant.util.DownloadEvent;
import savant.util.MiscUtils;
import savant.util.NetworkUtils;
import savant.util.RemoteFileCache;
import savant.util.export.FastaExporter;
import savant.util.export.TrackExporter;
import savant.view.dialog.FormatProgressDialog;

public class Tool
extends SavantPanelPlugin {
    static final Log LOG = LogFactory.getLog(Tool.class);
    private static final double PREP_PORTION = 0.25;
    private static final double WORK_PORTION = 0.75;
    private String baseCommand;
    private Pattern progressRegex;
    private Pattern errorRegex;
    private JTextArea console;
    List<ToolArgument> arguments = new ArrayList<ToolArgument>();
    private JPanel mainPanel;
    private JProgressBar progressBar;
    private JLabel progressInfo;
    private JButton cancelButton;
    private String workingRef;
    private RangeAdapter workingRange;
    boolean useHomoRefs;
    boolean loadUponCompletion = true;
    private Process toolProc;

    @Override
    public void init(JPanel panel) {
        this.mainPanel = panel;
        panel.setLayout(new CardLayout());
        ToolSettingsPanel settingsPanel = new ToolSettingsPanel(this);
        panel.add((Component)new JScrollPane(settingsPanel), "Settings");
        JPanel waitCard = new JPanel();
        waitCard.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 100, 0, 100);
        waitCard.add((Component)new JLabel(this.getDescriptor().getName()), gbc);
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(240, this.progressBar.getPreferredSize().height));
        waitCard.add((Component)this.progressBar, gbc);
        this.progressInfo = new JLabel();
        this.progressInfo.setAlignmentX(1.0f);
        Font f = this.progressInfo.getFont();
        f = f.deriveFont((float)f.getSize() - 2.0f);
        this.progressInfo.setFont(f);
        waitCard.add((Component)this.progressInfo, gbc);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (Tool.this.toolProc != null) {
                    Process p = Tool.this.toolProc;
                    Tool.this.toolProc = null;
                    p.destroy();
                }
                Tool.this.showCard("Settings");
            }
        });
        gbc.fill = 0;
        waitCard.add((Component)this.cancelButton, gbc);
        this.console = new JTextArea();
        this.console.setFont(f);
        this.console.setLineWrap(false);
        this.console.setEditable(false);
        JScrollPane consolePane = new JScrollPane(this.console);
        consolePane.setPreferredSize(new Dimension(800, 200));
        gbc.weighty = 1.0;
        gbc.insets = new Insets(30, 5, 5, 5);
        gbc.fill = 1;
        waitCard.add((Component)consolePane, gbc);
        panel.add((Component)waitCard, "Progress");
    }

    void parseDescriptor() throws XMLStreamException, FileNotFoundException {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(this.getDescriptor().getFile()));
        do {
            switch (reader.next()) {
                case 1: {
                    String elemName = reader.getLocalName().toLowerCase();
                    if (elemName.equals("tool")) {
                        this.baseCommand = reader.getElementText();
                        break;
                    }
                    if (elemName.equals("arg")) {
                        this.arguments.add(new ToolArgument(reader));
                        break;
                    }
                    if (elemName.equals("progress")) {
                        this.progressRegex = Pattern.compile(reader.getElementText());
                        break;
                    }
                    if (!elemName.equals("error")) break;
                    this.errorRegex = Pattern.compile(reader.getElementText());
                    break;
                }
                case 8: {
                    reader.close();
                    reader = null;
                }
            }
        } while (reader != null);
    }

    void displayCommandLine(JLabel l) {
        String command = "<html>";
        command = command + this.baseCommand;
        for (ToolArgument a : this.arguments) {
            if (a.value == null) {
                if (!a.required) continue;
                command = command + "<font color=\"red\"> " + a.flag + "</font>";
                continue;
            }
            if (!a.enabled) continue;
            if (a.type == ToolArgument.Type.MULTI) {
                String[] values;
                for (String val : values = a.value.split(",")) {
                    command = command + " " + a.flag + " " + val;
                }
                continue;
            }
            try {
                command = command + " " + a.flag + " " + this.getStringValue(a);
            }
            catch (ParseException px) {
                command = command + "<font color=\"red\"> " + a.flag + " " + a.value + "</font>";
            }
        }
        command = command + "</html>";
        l.setText(command);
    }

    void checkCommandLine() {
        for (ToolArgument a : this.arguments) {
            if (a.value == null) {
                if (!a.required) continue;
                throw new IllegalArgumentException(String.format("Required argument %s (%s) does not have a value.", a.flag, a.name));
            }
            if (!a.enabled) continue;
            switch (a.type) {
                case RANGE: {
                    try {
                        this.getStringValue(a);
                        break;
                    }
                    catch (ParseException px) {
                        throw new IllegalArgumentException(String.format("Unable to parse \"%s\" as a valid range.", a.value));
                    }
                }
            }
        }
    }

    List<String> buildCommandLine() throws IOException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.addAll(Arrays.asList(this.baseCommand.split("\\s")));
        if (((String)commandLine.get(0)).equals("java")) {
            for (int i = 2; i < commandLine.size(); ++i) {
                String arg = (String)commandLine.get(i);
                if (!arg.endsWith(".jar")) continue;
                if (arg.contains("/")) break;
                commandLine.set(i, new File(DirectorySettings.getPluginsDirectory(), arg).getAbsolutePath());
                break;
            }
        }
        for (ToolArgument a : this.arguments) {
            if (a.value == null) {
                if (!a.required) continue;
                throw new IllegalArgumentException(String.format("Required argument %s (%s) does not have a value.", a.flag, a.name));
            }
            if (!a.enabled) continue;
            if (a.type == ToolArgument.Type.MULTI) {
                String[] values;
                for (String val : values = a.value.split(",")) {
                    commandLine.add(a.flag);
                    commandLine.add(val);
                }
                continue;
            }
            commandLine.add(a.flag);
            try {
                switch (a.type) {
                    case BAM_INPUT_FILE: {
                        commandLine.add(this.getLocalFile(a.value, true).getAbsolutePath());
                        break;
                    }
                    case FASTA_INPUT_FILE: {
                        commandLine.add(this.getLocalFile(a.value, false).getAbsolutePath());
                        break;
                    }
                    default: {
                        commandLine.add(this.getStringValue(a));
                        break;
                    }
                }
            }
            catch (ParseException ignored) {
            }
        }
        return commandLine;
    }

    public String getStringValue(ToolArgument a) throws ParseException {
        switch (a.type) {
            case BAM_INPUT_FILE: {
                return a.value;
            }
            case RANGE: {
                String ref;
                this.parseWorkingRange(a.value);
                if (this.workingRef == null) break;
                String string = ref = this.useHomoRefs ? MiscUtils.homogenizeSequence(this.workingRef) : this.workingRef;
                if (this.workingRange != null) {
                    return String.format("%s:%d-%d", ref, this.workingRange.getFrom(), this.workingRange.getTo());
                }
                return ref;
            }
        }
        return a.value;
    }

    private void parseWorkingRange(String val) throws ParseException {
        if (val == null || val.length() == 0) {
            this.workingRef = null;
            this.workingRange = null;
        } else {
            int colonPos = val.indexOf(58);
            if (colonPos > 0) {
                Bookmark b = new Bookmark(val);
                this.workingRef = b.getReference();
                this.workingRange = b.getRange();
            } else {
                this.workingRef = val;
                this.workingRange = null;
            }
        }
    }

    private File getLocalFile(String fileOrURI, boolean canUseDirectly) throws IOException {
        URI uri = NetworkUtils.getURIFromPath(fileOrURI);
        if (canUseDirectly && uri.getScheme().equals("file")) {
            return new File(uri);
        }
        StringBuilder source = new StringBuilder(uri.toString());
        int savantExt = source.lastIndexOf(".savant");
        if (savantExt > 0) {
            source.setLength(savantExt);
        }
        if (RemoteFileCache.findCacheEntry(source.toString()) == null && this.workingRef != null) {
            int lastDot = source.lastIndexOf(".");
            source.insert(lastDot, "-" + this.workingRef);
            if (RemoteFileCache.findCacheEntry(source.toString()) == null && this.workingRange != null) {
                lastDot = source.lastIndexOf(".");
                source.insert(lastDot, String.format(":%d-%d", this.workingRange.getFrom(), this.workingRange.getTo()));
            }
        }
        return RemoteFileCache.getCacheFile(uri.toURL(), source.toString(), 0, 0L);
    }

    void execute() {
        try {
            this.checkCommandLine();
            this.showCard("Progress");
            new ToolWorker().execute();
        }
        catch (IllegalArgumentException x) {
            DialogUtils.displayMessage(x.getMessage());
        }
    }

    private void showCard(String card) {
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, card);
    }

    private class ToolWorker
    extends BackgroundWorker<File> {
        List<ToolArgument> missingFiles = new ArrayList<ToolArgument>();
        int inputIndex;
        private String errorMessage;
        private File destFile;

        private ToolWorker() {
        }

        @Override
        protected void showProgress(double fraction) {
            Tool.this.progressBar.setIndeterminate(fraction < 0.0);
            Tool.this.progressBar.setValue((int)(fraction * 100.0));
        }

        @Override
        protected File doInBackground() throws Exception {
            this.showProgress(0.0);
            Tool.this.cancelButton.setText("Cancel");
            Tool.this.console.setText("");
            Tool.this.progressInfo.setText("Preparing input files\u2026");
            this.prepareInputs();
            Tool.this.progressInfo.setText("Running tool\u2026");
            this.runTool();
            if (Tool.this.loadUponCompletion) {
                String destPath = this.destFile.getAbsolutePath();
                FileType guess = SavantFileFormatterUtils.guessFileTypeFromPath(destPath);
                if (guess == FileType.INTERVAL_BAM) {
                    FrameController.getInstance().addTrackFromPath(destPath, null, null);
                } else {
                    File formattedFile = SavantFileFormatterUtils.getFormattedFile(destPath, guess);
                    SavantFileFormatter sff = SavantFileFormatter.getFormatter(this.destFile, formattedFile, guess);
                    if (sff != null) {
                        FormatProgressDialog fpd = new FormatProgressDialog(DialogUtils.getMainWindow(), sff, true);
                        fpd.setLocationRelativeTo(DialogUtils.getMainWindow());
                        fpd.setVisible(true);
                    }
                }
            }
            Tool.this.progressInfo.setText("");
            return this.destFile;
        }

        @Override
        protected void showSuccess(File result) {
            Tool.this.cancelButton.setText("Done");
        }

        private void prepareInputs() throws IOException, InterruptedException {
            ToolArgument bamArg = null;
            for (ToolArgument a : Tool.this.arguments) {
                if (!a.enabled) continue;
                switch (a.type) {
                    case BAM_INPUT_FILE: {
                        if (!NetworkUtils.getURIFromPath(a.value).getScheme().equals("file")) {
                            this.missingFiles.add(a);
                        }
                        bamArg = a;
                        break;
                    }
                    case FASTA_INPUT_FILE: {
                        this.missingFiles.add(a);
                        break;
                    }
                    case OUTPUT_FILE: {
                        this.destFile = new File(a.value);
                    }
                }
            }
            this.inputIndex = 0;
            FastaExporter fastaExp = null;
            for (ToolArgument a : this.missingFiles) {
                File f = Tool.this.getLocalFile(a.value, false);
                if (!f.exists()) {
                    LOG.info((Object)(f + " not found, exporting."));
                    TrackExporter exp = TrackExporter.getExporter(a.value, f);
                    exp.addListener(new Listener<DownloadEvent>(){

                        @Override
                        public void handleEvent(DownloadEvent event) {
                            switch (event.getType()) {
                                case PROGRESS: {
                                    double prog = event.getProgress();
                                    if (prog >= 0.0) {
                                        ToolWorker.this.showProgress(0.25 * ((double)ToolWorker.this.inputIndex + event.getProgress()) / (double)ToolWorker.this.missingFiles.size());
                                        break;
                                    }
                                    ToolWorker.this.showProgress(-1.0);
                                    break;
                                }
                                case COMPLETED: {
                                    try {
                                        RemoteFileCache.updateCacheEntry(event.getFile());
                                        break;
                                    }
                                    catch (Exception x) {
                                        LOG.error((Object)("Unable to update cache entry for " + event.getFile()), (Throwable)x);
                                    }
                                }
                            }
                        }
                    });
                    exp.export(Tool.this.workingRef, Tool.this.workingRange);
                    if (exp instanceof FastaExporter) {
                        fastaExp = (FastaExporter)exp;
                    }
                }
                this.showProgress((double)(++this.inputIndex) * 0.25 / (double)this.missingFiles.size());
            }
            if (bamArg != null && fastaExp != null) {
                SAMSequenceDictionary samDict = ((BAMDataSourceAdapter)((Object)TrackUtils.getTrackDataSource(bamArg.value))).getHeader().getSequenceDictionary();
                fastaExp.createFakeIndex(samDict, Tool.this.workingRef == null);
                fastaExp.createFakeSequenceDictionary(samDict);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void runTool() throws IOException {
            block7: {
                List<String> commandLine = Tool.this.buildCommandLine();
                ProcessBuilder builder = new ProcessBuilder(commandLine);
                builder.redirectErrorStream(true);
                Tool.this.toolProc = builder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(Tool.this.toolProc.getInputStream()));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        Matcher m;
                        line = line + "\n";
                        Tool.this.console.append(line);
                        if (Tool.this.errorRegex != null && (m = Tool.this.errorRegex.matcher(line)).find()) {
                            this.errorMessage = m.group(1);
                            LOG.info((Object)("Retrieved error message \"" + this.errorMessage + "\"."));
                            continue;
                        }
                        if (Tool.this.progressRegex == null || !(m = Tool.this.progressRegex.matcher(line)).find()) continue;
                        String progress = m.group(1);
                        try {
                            this.showProgress(0.25 + Double.valueOf(progress) * 0.75 * 0.01);
                        }
                        catch (NumberFormatException ignored) {
                            LOG.info((Object)("Unable to interpret \"" + progress + "\" as a percentage."));
                        }
                    }
                    Tool.this.toolProc = null;
                }
                catch (IOException x) {
                    if (Tool.this.toolProc == null) break block7;
                    throw x;
                }
            }
            if (this.errorMessage != null) {
                throw new IOException(this.errorMessage);
            }
        }
    }
}

