/*
 * Decompiled with CFR 0.152.
 */
package savant.plugin;

import javax.xml.stream.XMLStreamReader;

public class ToolArgument {
    final String name;
    final String flag;
    final Type type;
    final boolean required;
    String[] choices;
    String value;
    boolean enabled;

    public ToolArgument(XMLStreamReader reader) {
        this.name = reader.getAttributeValue(null, "name");
        this.flag = reader.getAttributeValue(null, "flag");
        this.type = Enum.valueOf(Type.class, reader.getAttributeValue(null, "type"));
        this.enabled = this.required = Boolean.parseBoolean(reader.getAttributeValue(null, "required"));
        switch (this.type) {
            case BOOL: 
            case INT: 
            case FLOAT: {
                this.value = reader.getAttributeValue(null, "default");
                break;
            }
            case LIST: {
                String attr = reader.getAttributeValue(null, "choices");
                this.choices = attr.split(",\\s*");
                this.value = reader.getAttributeValue(null, "default");
                if (this.value != null) break;
                this.value = this.choices[0];
                break;
            }
            case MULTI: {
                String attr = reader.getAttributeValue(null, "choices");
                this.choices = attr.split(",\\s*");
            }
        }
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static enum Type {
        BOOL,
        INT,
        FLOAT,
        LIST,
        MULTI,
        RANGE,
        OUTPUT_FILE,
        BAM_INPUT_FILE,
        FASTA_INPUT_FILE;

    }
}

