/*
 * Decompiled with CFR 0.152.
 */
package savant.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import savant.api.data.Record;
import savant.api.event.SelectionChangedEvent;
import savant.util.Controller;
import savant.util.Range;

public class SelectionController
extends Controller<SelectionChangedEvent> {
    private static SelectionController instance;
    private Map<String, List<Record>> map = Collections.synchronizedMap(new HashMap());
    private Map<String, List<Record>> currentMap = new HashMap<String, List<Record>>();
    private Map<String, Range> rangeMap = new HashMap<String, Range>();

    public static synchronized SelectionController getInstance() {
        if (instance == null) {
            instance = new SelectionController();
        }
        return instance;
    }

    private SelectionController() {
    }

    public boolean toggleSelection(String name, Record o) {
        this.ensureKey(name);
        int pos = this.binarySearchSelected(name, o);
        if (pos == -1) {
            this.map.get(name).add(o);
            this.addToCurrentSelected(name, o);
            Collections.sort(this.map.get(name));
        } else {
            this.map.get(name).remove(o);
            this.removeFromCurrentSelected(name, o);
        }
        this.fireEvent(new SelectionChangedEvent());
        return pos == -1;
    }

    public void addSelection(String name, Record o) {
        this.addSelectionWithoutEvent(name, o);
        this.fireEvent(new SelectionChangedEvent());
    }

    private void addSelectionWithoutEvent(String name, Record o) {
        this.ensureKey(name);
        int pos = this.binarySearchSelected(name, o);
        if (pos == -1) {
            this.map.get(name).add(o);
            Collections.sort(this.map.get(name));
            this.addToCurrentSelected(name, o);
        }
    }

    public void removeSelectionWithoutEvent(String name, Record o) {
        this.map.get(name).remove(o);
        this.removeFromCurrentSelected(name, o);
    }

    public void removeSelection(String name, Record o) {
        this.removeSelectionWithoutEvent(name, o);
        this.fireEvent(new SelectionChangedEvent());
    }

    public void removeAll(String name) {
        if (this.map.containsKey(name)) {
            this.map.get(name).clear();
            this.currentMap.get(name).clear();
            this.rangeMap.remove(name);
            this.fireEvent(new SelectionChangedEvent());
        }
    }

    public void removeAll() {
        this.map.clear();
        this.currentMap.clear();
        this.rangeMap.clear();
        this.fireEvent(new SelectionChangedEvent());
    }

    public List<Record> getSelections(String name) {
        if (this.map.get(name) == null) {
            return null;
        }
        return Collections.unmodifiableList(this.map.get(name));
    }

    public boolean hasSelected(String name) {
        return this.map.containsKey(name) && !this.map.get(name).isEmpty();
    }

    private int binarySearchSelected(String name, Comparable key) {
        List<Record> selected = this.map.get(name);
        if (selected == null) {
            return -1;
        }
        int start = 0;
        int end = selected.size();
        while (start < end) {
            int mid = (start + end) / 2;
            int compare = key.compareTo((Comparable)selected.get(mid));
            if (compare < 0) {
                end = mid;
                continue;
            }
            if (compare > 0) {
                start = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private List<Record> getSelectedFromList(String name, List<Record> data) {
        ArrayList<Record> list = new ArrayList<Record>();
        if (this.hasSelected(name)) {
            for (int i = 0; i < data.size(); ++i) {
                Record o = data.get(i);
                int pos = this.binarySearchSelected(name, o);
                if (pos == -1) continue;
                list.add(o);
            }
        }
        return list;
    }

    public List<Record> getSelectedFromList(String name, Range range, List<Record> data) {
        if (range.equals(this.rangeMap.get(name)) && this.currentMap.get(name) != null) {
            return this.currentMap.get(name);
        }
        this.rangeMap.put(name, range);
        List<Record> currentSelected = this.getSelectedFromList(name, data);
        this.currentMap.put(name, currentSelected);
        return currentSelected;
    }

    private void addToCurrentSelected(String name, Record o) {
        if (!this.currentMap.containsKey(name)) {
            this.currentMap.put(name, new ArrayList());
        }
        this.currentMap.get(name).add(o);
        this.rangeMap.remove(name);
    }

    private void removeFromCurrentSelected(String name, Record o) {
        if (this.currentMap.containsKey(name)) {
            this.currentMap.get(name).remove(o);
            this.rangeMap.remove(name);
        }
    }

    private void ensureKey(String name) {
        if (!this.map.containsKey(name)) {
            this.map.put(name, new ArrayList());
        }
    }

    public void addMultipleSelections(String name, List<Record> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addSelectionWithoutEvent(name, list.get(i));
        }
        this.ensureKey(name);
        Collections.sort(this.map.get(name));
        this.fireEvent(new SelectionChangedEvent());
    }

    public void toggleGroup(String name, List<Record> group) {
        this.ensureKey(name);
        boolean notSelected = false;
        for (Record r : group) {
            if (this.binarySearchSelected(name, r) != -1) continue;
            notSelected = true;
            break;
        }
        if (notSelected) {
            for (Record r : group) {
                this.addSelectionWithoutEvent(name, r);
            }
        } else {
            for (Record r : group) {
                this.removeSelectionWithoutEvent(name, r);
            }
        }
        this.fireEvent(new SelectionChangedEvent());
    }
}

