/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import java.awt.Color;
import java.util.EnumMap;
import savant.settings.PersistentSettings;
import savant.util.ColourKey;

public class ColourSettings {
    private static final EnumMap<ColourKey, Color> DEFAULT_SETTINGS = new EnumMap(ColourKey.class);
    private static PersistentSettings settings;

    public static Color getColor(ColourKey key) {
        return settings.getColor(key, DEFAULT_SETTINGS.get((Object)key));
    }

    public static void setColor(ColourKey key, Color value) {
        settings.setColor(key, value);
    }

    static {
        DEFAULT_SETTINGS.put(ColourKey.A, new Color(27, 97, 97));
        DEFAULT_SETTINGS.put(ColourKey.C, new Color(162, 45, 45));
        DEFAULT_SETTINGS.put(ColourKey.G, new Color(36, 130, 36));
        DEFAULT_SETTINGS.put(ColourKey.T, new Color(162, 98, 45));
        DEFAULT_SETTINGS.put(ColourKey.N, new Color(100, 100, 100));
        DEFAULT_SETTINGS.put(ColourKey.DELETED_BASE, Color.BLACK);
        DEFAULT_SETTINGS.put(ColourKey.INSERTED_BASE, new Color(204, 102, 255));
        DEFAULT_SETTINGS.put(ColourKey.SKIPPED, Color.GRAY);
        DEFAULT_SETTINGS.put(ColourKey.FORWARD_STRAND, new Color(0, 131, 192));
        DEFAULT_SETTINGS.put(ColourKey.REVERSE_STRAND, new Color(0, 174, 255));
        DEFAULT_SETTINGS.put(ColourKey.CONCORDANT_LENGTH, new Color(0, 174, 255));
        DEFAULT_SETTINGS.put(ColourKey.DISCORDANT_LENGTH, Color.RED);
        DEFAULT_SETTINGS.put(ColourKey.ONE_READ_INVERTED, Color.BLUE);
        DEFAULT_SETTINGS.put(ColourKey.EVERTED_PAIR, Color.YELLOW);
        DEFAULT_SETTINGS.put(ColourKey.UNMAPPED_MATE, Color.GRAY);
        DEFAULT_SETTINGS.put(ColourKey.CONTINUOUS_FILL, new Color(0, 174, 255, 200));
        DEFAULT_SETTINGS.put(ColourKey.CONTINUOUS_LINE, new Color(0, 50, 50, 50));
        DEFAULT_SETTINGS.put(ColourKey.POINT_FILL, new Color(0, 174, 255, 150));
        DEFAULT_SETTINGS.put(ColourKey.POINT_LINE, Color.BLACK);
        DEFAULT_SETTINGS.put(ColourKey.INTERVAL_LINE, Color.GRAY);
        DEFAULT_SETTINGS.put(ColourKey.INTERVAL_TEXT, Color.DARK_GRAY);
        DEFAULT_SETTINGS.put(ColourKey.OPAQUE_GRAPH, new Color(0, 174, 255));
        DEFAULT_SETTINGS.put(ColourKey.TRANSLUCENT_GRAPH, new Color(0, 174, 255, 100));
        DEFAULT_SETTINGS.put(ColourKey.SPLITTER, new Color(210, 210, 210));
        DEFAULT_SETTINGS.put(ColourKey.GRAPH_PANE_MESSAGE, Color.DARK_GRAY);
        DEFAULT_SETTINGS.put(ColourKey.GRAPH_PANE_BACKGROUND_TOP, Color.WHITE);
        DEFAULT_SETTINGS.put(ColourKey.GRAPH_PANE_BACKGROUND_BOTTOM, new Color(210, 210, 210));
        DEFAULT_SETTINGS.put(ColourKey.GRAPH_PANE_ZOOM_FILL, new Color(0, 0, 255, 100));
        DEFAULT_SETTINGS.put(ColourKey.GRAPH_PANE_SELECTION_FILL, new Color(120, 70, 10, 100));
        DEFAULT_SETTINGS.put(ColourKey.AXIS_GRID, Color.LIGHT_GRAY);
        DEFAULT_SETTINGS.put(ColourKey.HEATMAP_LOW, new Color(0, 0, 255));
        DEFAULT_SETTINGS.put(ColourKey.HEATMAP_MEDIUM, new Color(192, 128, 192));
        DEFAULT_SETTINGS.put(ColourKey.HEATMAP_HIGH, new Color(255, 0, 0));
        settings = PersistentSettings.getInstance();
    }
}

