/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import com.jidesoft.action.CommandBar;
import com.jidesoft.grid.MultilineTableCellRenderer;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyPane;
import com.jidesoft.grid.PropertyTable;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.grid.PropertyTableSearchable;
import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.TableStyleProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import savant.controller.TrackController;
import savant.settings.ColourSettings;
import savant.settings.PersistentSettings;
import savant.settings.Section;
import savant.settings.SettingsDialog;
import savant.util.ColourKey;
import savant.view.tracks.Track;

public class ColourSettingsSection
extends Section {
    protected PropertyPane pane;
    protected PropertyTableModel model;
    protected EnumMap<ColourKey, Color> map = new EnumMap(ColourKey.class);

    public String getTitle() {
        return "Colour Schemes";
    }

    @Override
    public void applyChanges() {
        if (this.pane != null) {
            try {
                for (ColourKey k : this.map.keySet()) {
                    ColourSettings.setColor(k, this.map.get((Object)k));
                }
                PersistentSettings.getInstance().store();
                for (Track t : TrackController.getInstance().getTracks()) {
                    t.getFrame().forceRedraw();
                }
            }
            catch (IOException iox) {
                this.LOG.error((Object)"Unable to save colour settings.", (Throwable)iox);
            }
        }
    }

    public void lazyInitialize() {
        GridBagConstraints gbc = this.getFullRowConstraints();
        this.add(SettingsDialog.getHeader(this.getTitle()), gbc);
        ArrayList list = new ArrayList();
        this.model = new PropertyTableModel(list);
        PropertyTable table = new PropertyTable((TableModel)this.model){

            public TableCellRenderer getCellRenderer(int row, int column) {
                Property property = this.getPropertyTableModel().getPropertyAt(row);
                if (property != null && "Text".equals(property.getName()) && column == 1) {
                    return new MultilineTableCellRenderer();
                }
                return super.getCellRenderer(row, column);
            }
        };
        table.setPreferredScrollableViewportSize(new Dimension(400, 600));
        table.expandFirstLevel();
        table.setRowAutoResizes(true);
        PropertyTableSearchable searchable = new PropertyTableSearchable((JTable)table);
        searchable.setRecursive(true);
        table.setTableStyleProvider((TableStyleProvider)new RowStripeTableStyleProvider());
        this.pane = new PropertyPane(table){

            protected JComponent createToolBarComponent() {
                CommandBar toolBar = new CommandBar();
                toolBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
                toolBar.setFloatable(false);
                toolBar.setStretch(true);
                toolBar.setPaintBackground(false);
                toolBar.setChevronAlwaysVisible(false);
                return toolBar;
            }
        };
        this.pane.setShowDescription(false);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)this.pane, gbc);
    }

    @Override
    public void populate() {
        this.addProperty(ColourKey.A, "Nucleotide");
        this.addProperty(ColourKey.C, "Nucleotide");
        this.addProperty(ColourKey.G, "Nucleotide");
        this.addProperty(ColourKey.T, "Nucleotide");
        this.addProperty(ColourKey.FORWARD_STRAND, "Interval");
        this.addProperty(ColourKey.REVERSE_STRAND, "Interval");
        this.addProperty(ColourKey.CONCORDANT_LENGTH, "Interval");
        this.addProperty(ColourKey.DISCORDANT_LENGTH, "Interval");
        this.addProperty(ColourKey.ONE_READ_INVERTED, "Interval");
        this.addProperty(ColourKey.EVERTED_PAIR, "Interval");
        this.addProperty(ColourKey.UNMAPPED_MATE, "Interval");
        this.addProperty(ColourKey.CONTINUOUS_FILL, "Continuous");
        this.addProperty(ColourKey.CONTINUOUS_LINE, "Continuous");
        this.addProperty(ColourKey.POINT_FILL, "Point");
        this.addProperty(ColourKey.POINT_LINE, "Point");
        this.model.expandAll();
    }

    public void addProperty(ColourKey key, String category) {
        int pos = this.findProperty(key);
        if (pos == -1) {
            ColourProperty property = new ColourProperty(key, key.getDescription(), Color.class, category);
            this.model.getOriginalProperties().add(property);
            this.model.refresh();
        }
        this.map.put(key, ColourSettings.getColor(key));
    }

    private int findProperty(ColourKey key) {
        int result = -1;
        for (int j = 0; j < this.model.getOriginalProperties().size(); ++j) {
            if (((ColourProperty)((Object)this.model.getOriginalProperties().get(j))).key != key) continue;
            result = j;
            break;
        }
        return result;
    }

    class ColourProperty
    extends Property {
        private final ColourKey key;

        public ColourProperty(ColourKey key, String description, Class type, String category) {
            super(key.getName(), description, type, category);
            this.key = key;
        }

        public void setValue(Object value) {
            Object old = this.getValue();
            if (!old.equals(value)) {
                ColourSettingsSection.this.enableApplyButton();
                ColourSettingsSection.this.map.put(this.key, (Color)value);
            }
        }

        public Object getValue() {
            return ColourSettingsSection.this.map.get((Object)this.key);
        }

        public boolean hasValue() {
            return ColourSettingsSection.this.map.get((Object)this.key) != null;
        }
    }
}

