/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.settings.DirectorySettings;
import savant.util.IOUtils;
import savant.util.MiscUtils;
import savant.util.NetworkUtils;

public class IndexCache {
    private static final Log LOG = LogFactory.getLog(IndexCache.class);
    private static IndexCache instance;
    private File cacheDir;
    private Properties tags;
    private Properties indices;
    private File tagPropFile = new File(this.getCacheDir(), "etags");
    private File indexPropFile = new File(this.getCacheDir(), "indices");

    public static synchronized IndexCache getInstance() {
        if (instance == null) {
            instance = new IndexCache();
        }
        return instance;
    }

    private IndexCache() {
    }

    private File getIndex(URI uri, String extension, String alternate) throws IOException {
        String cachedTag;
        String indexURLString = uri.toString() + "." + extension;
        URL indexURL = new URL(indexURLString);
        String hash = null;
        try {
            hash = NetworkUtils.getHash(indexURL);
        }
        catch (IOException e) {
            LOG.warn((Object)("Remote file can't be accessed: " + indexURL), (Throwable)e);
        }
        if (hash == null) {
            indexURLString = uri.toString().replace("." + alternate, "." + extension);
            indexURL = new URL(indexURLString);
            hash = NetworkUtils.getHash(indexURL);
        }
        String indexFilename = this.getIndexFileName(uri.toString(), indexURLString);
        File indexFile = new File(this.getCacheDir(), indexFilename);
        if (indexFile.exists() && ((cachedTag = this.getETagForURL(uri.toString())) == null || hash == null || !hash.equals(cachedTag))) {
            indexFile.delete();
        }
        if (!indexFile.exists()) {
            NetworkUtils.downloadFile(indexURL, this.cacheDir, indexFilename);
            this.setETagForURL(hash, indexURLString);
        }
        return indexFile;
    }

    public void clearCache() {
        IOUtils.deleteDirectory(this.getCacheDir());
    }

    private synchronized Properties getETags() {
        if (this.tags == null) {
            this.tags = this.loadPropertiesFile(this.tagPropFile);
        }
        return this.tags;
    }

    private String getETagForURL(String URL2) {
        return this.getETags().getProperty(URL2);
    }

    private void setETagForURL(String etag, String url) {
        if (etag == null) {
            this.getETags().remove(url);
        } else {
            this.getETags().put(url, etag);
        }
        this.writePropertiesToFile(this.getETags(), this.tagPropFile);
    }

    private synchronized Properties getIndices() {
        if (this.indices == null) {
            this.indices = this.loadPropertiesFile(this.indexPropFile);
        }
        return this.indices;
    }

    private String getIndexForURL(String URL2) {
        return this.getIndices().getProperty(URL2);
    }

    private void setIndexForURL(String index, String url) {
        this.getIndices().put(url, index);
        this.writePropertiesToFile(this.getIndices(), this.indexPropFile);
    }

    private File getCacheDir() {
        if (this.cacheDir == null) {
            this.cacheDir = new File(DirectorySettings.getSavantDirectory(), "index");
            if (!this.cacheDir.exists()) {
                this.cacheDir.mkdir();
            }
        }
        return this.cacheDir;
    }

    private synchronized String getIndexFileName(String url, String indexURL) {
        String indexFilename = this.getIndexForURL(url);
        if (indexFilename == null) {
            String extension = MiscUtils.getExtension(indexURL);
            indexFilename = indexURL.substring(0, indexURL.lastIndexOf("."));
            int offset = indexURL.lastIndexOf("/");
            String name = indexURL.substring(offset + 1);
            indexFilename = name + System.currentTimeMillis() + "." + extension;
            this.setIndexForURL(indexFilename, url);
        }
        return indexFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFile(File propFile) {
        Properties result = new Properties();
        if (propFile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(propFile);
                result.load(is);
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)"Properties file not found", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)"Exception reading properties file", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertiesToFile(Properties props, File propFile) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(propFile);
            props.store(os, null);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Unable to save Cache properties file", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to save Cache properties file", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public static File getIndexFile(URI uri, String extension, String alternate) throws IOException {
        String proto = uri.getScheme();
        if ("http".equals(proto) || "https".equals(proto) || "ftp".equals(proto)) {
            return IndexCache.getInstance().getIndex(uri, extension, alternate);
        }
        String path = new File(uri).getAbsolutePath();
        File indexFile = new File(path + "." + extension);
        if (indexFile.exists()) {
            return indexFile;
        }
        File indexFile2 = new File(path.replace("." + alternate, "." + extension));
        if (indexFile2.exists()) {
            return indexFile2;
        }
        throw new FileNotFoundException(indexFile.getPath());
    }
}

