/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.SortedMap;
import java.util.TreeMap;
import savant.api.data.Interval;
import savant.api.data.IntervalRecord;
import savant.api.data.Record;

public class IntervalPacker {
    private List<Record> data;
    private static final double ONE_MILLIONTH = Math.pow(10.0, -6.0);

    public IntervalPacker(List<Record> data) {
        this.data = data;
    }

    public List<List<IntervalRecord>> pack(int breathingSpace) {
        int numdata = this.data.size();
        ArrayList<List<IntervalRecord>> levels = new ArrayList<List<IntervalRecord>>();
        TreeMap<Double, Integer> rightMostPositions = new TreeMap<Double, Integer>();
        PriorityQueue availableLevels = new PriorityQueue();
        int highestLevel = -1;
        for (int i = 0; i < numdata; ++i) {
            int level;
            Integer availableLevel;
            SortedMap headMap;
            int intervalStart;
            IntervalRecord record = (IntervalRecord)this.data.get(i);
            Interval inter = record.getInterval();
            int intervalEnd = inter.getEnd();
            if (intervalEnd < (intervalStart = inter.getStart()) || intervalEnd < 0 || intervalStart < 0) continue;
            if (!rightMostPositions.isEmpty() && (headMap = rightMostPositions.headMap(Double.valueOf(intervalStart))) != null && !headMap.isEmpty()) {
                Iterator<Double> positions = headMap.keySet().iterator();
                while (positions.hasNext()) {
                    Double position = positions.next();
                    availableLevels.add(headMap.get(position));
                    positions.remove();
                }
            }
            if ((availableLevel = (Integer)availableLevels.poll()) == null) {
                level = ++highestLevel;
                ArrayList newLevel = new ArrayList();
                levels.add(newLevel);
            } else {
                level = availableLevel;
            }
            levels.get(level).add(record);
            double tieBreaker = (double)(level + 1) * ONE_MILLIONTH;
            rightMostPositions.put((double)intervalEnd + (double)breathingSpace - tieBreaker, level);
        }
        return levels;
    }

    private boolean intersectsOne(List<Interval> intervalList, Interval inter, int gap) {
        for (Interval i2 : intervalList) {
            if (i2.intersects(inter)) {
                return true;
            }
            if (Math.abs(inter.getStart() - i2.getEnd()) >= gap && Math.abs(i2.getStart() - inter.getEnd()) >= 5) continue;
            return true;
        }
        return false;
    }
}

