/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.io.IOException;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.util.NetworkUtils;

public class Version
implements Comparable {
    private static final Log LOG = LogFactory.getLog(Version.class);
    int major;
    int minor;
    int revision;

    public Version(String versionString) {
        String[] pieces = versionString.split("\\.");
        if (pieces.length != 3) {
            throw new IllegalArgumentException(String.format("{0} is not a valid version number.", versionString));
        }
        this.major = Integer.parseInt(pieces[0]);
        this.minor = Integer.parseInt(pieces[1]);
        this.revision = Integer.parseInt(pieces[2]);
    }

    public static Version fromURL(URL url) throws IOException {
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(NetworkUtils.openStream(url));
            boolean done = false;
            boolean foundCurrentVersion = false;
            do {
                switch (reader.next()) {
                    case 1: {
                        String elemName = reader.getLocalName();
                        if (elemName.equals("version") && "current_release".equals(reader.getAttributeValue(null, "status"))) {
                            foundCurrentVersion = true;
                            break;
                        }
                        if (foundCurrentVersion && elemName.equals("name")) {
                            return new Version(reader.getElementText());
                        }
                        foundCurrentVersion = false;
                        break;
                    }
                    case 8: {
                        reader.close();
                        done = true;
                    }
                }
            } while (!done);
        }
        catch (XMLStreamException x) {
            throw new IOException("Unable to get version number from web-site.", x);
        }
        return null;
    }

    public int compareTo(Object o) {
        if (o instanceof Version) {
            Version v1 = this;
            Version v2 = (Version)o;
            if (v1.major > v2.major) {
                return 1;
            }
            if (v1.major < v2.major) {
                return -1;
            }
            if (v1.minor > v2.minor) {
                return 1;
            }
            if (v1.minor < v2.minor) {
                return -1;
            }
            if (v1.revision > v2.revision) {
                return 1;
            }
            if (v1.revision < v2.revision) {
                return -1;
            }
            return 0;
        }
        return 1;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.revision;
    }
}

