/*
 * Decompiled with CFR 0.152.
 */
package savant.view.dialog;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.swing.TableSearchable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import savant.api.util.DialogUtils;
import savant.api.util.PluginUtils;
import savant.util.MiscUtils;
import savant.view.swing.model.TreeBrowserEntry;
import savant.view.swing.model.TreeBrowserModel;

public class PluginRepositoryDialog
extends JDialog {
    private static final Log LOG = LogFactory.getLog(PluginRepositoryDialog.class);
    private TreeTable table;

    public PluginRepositoryDialog(Window parent, String title, String buttonText, File xmlFile) throws JDOMException, IOException {
        super(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.add(this.getCenterPanel(PluginRepositoryDialog.getDownloadTreeRows(xmlFile)), "Center");
        JPanel bottomBar = new JPanel(new FlowLayout(2, 5, 5));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginRepositoryDialog.this.setVisible(false);
            }
        });
        bottomBar.add(cancelButton);
        JButton installButton = new JButton(buttonText);
        installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginRepositoryDialog.this.downloadSelectedItem(false);
            }
        });
        bottomBar.add(installButton);
        this.add((Component)bottomBar, "South");
        this.setPreferredSize(new Dimension(1000, 500));
        this.pack();
        this.getRootPane().setDefaultButton(installButton);
        MiscUtils.registerCancelButton(cancelButton);
        this.setLocationRelativeTo(parent);
    }

    private void downloadSelectedItem(boolean ignoreBranchSelected) {
        TreeBrowserEntry r = (TreeBrowserEntry)this.table.getRowAt(this.table.getSelectedRow());
        if (r != null && r.isLeaf()) {
            this.setVisible(false);
            PluginUtils.installPlugin(r.getURL());
        } else if (!ignoreBranchSelected) {
            DialogUtils.displayMessage("Please select a file");
        }
    }

    private static TreeBrowserEntry parseDocumentTreeRow(Element root) {
        if (root.getName().equals("branch")) {
            ArrayList<TreeBrowserEntry> children = new ArrayList<TreeBrowserEntry>();
            for (Object o : root.getChildren()) {
                Element c = (Element)o;
                children.add(PluginRepositoryDialog.parseDocumentTreeRow(c));
            }
            return new TreeBrowserEntry(root.getAttributeValue("name"), children);
        }
        if (root.getName().equals("leaf")) {
            try {
                return new PluginBrowserEntry(root);
            }
            catch (MalformedURLException ex) {
                LOG.error((Object)ex);
            }
        }
        return null;
    }

    private static List<TreeBrowserEntry> getDownloadTreeRows(File f) throws JDOMException, IOException {
        ArrayList<TreeBrowserEntry> roots = new ArrayList<TreeBrowserEntry>();
        Document d = new SAXBuilder().build(f);
        Element root = d.getRootElement();
        TreeBrowserEntry treeroot = PluginRepositoryDialog.parseDocumentTreeRow(root);
        roots.add(treeroot);
        return roots;
    }

    public final Component getCenterPanel(List<TreeBrowserEntry> roots) {
        this.table = new TreeTable((TableModel)((Object)new TreeBrowserModel(roots){

            @Override
            public String[] getColumnNames() {
                return new String[]{"Name", "Description", "Web Site"};
            }

            @Override
            public CellStyle getCellStyleAt(int rowIndex, int columnIndex) {
                return null;
            }
        }));
        this.table.setSortable(true);
        this.table.setRespectRenderPreferredHeight(true);
        this.table.setExpandAllAllowed(true);
        this.table.setShowTreeLines(false);
        this.table.setSortingEnabled(false);
        this.table.setRowHeight(18);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setSelectionMode(0);
        this.table.expandFirstLevel();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object o;
                int col = PluginRepositoryDialog.this.table.columnAtPoint(e.getPoint());
                if (col == 2 && (o = PluginRepositoryDialog.this.table.getModel().getValueAt(PluginRepositoryDialog.this.table.rowAtPoint(e.getPoint()), col)) != null && o instanceof URL) {
                    System.out.println(o.toString());
                    try {
                        Desktop.getDesktop().browse(((URL)o).toURI());
                    }
                    catch (Exception x) {
                        LOG.error((Object)("Unable to open link for " + o), (Throwable)x);
                    }
                    return;
                }
                if (e.getClickCount() == 2) {
                    PluginRepositoryDialog.this.downloadSelectedItem(true);
                }
            }
        });
        this.table.setSelectRowWhenToggling(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(520);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new FileRowCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new WebLinkRenderer());
        TableSearchable searchable = new TableSearchable((JTable)this.table){

            protected String convertElementToString(Object item) {
                if (item instanceof TreeBrowserEntry) {
                    return ((TreeBrowserEntry)item).getType();
                }
                return super.convertElementToString(item);
            }
        };
        searchable.setMainIndex(0);
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        JPanel panel = new JPanel(new BorderLayout(6, 6));
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize(new Dimension(800, 500));
        return panel;
    }

    private static class WebLinkRenderer
    extends DefaultTableCellRenderer {
        private WebLinkRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value != null && value instanceof URL) {
                URL url = (URL)value;
                value = String.format("<html><a href=\"%s\">%s</a></html>", url, url.getHost());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        }
    }

    private static class PluginBrowserEntry
    extends TreeBrowserEntry {
        private URL webSite;

        private PluginBrowserEntry(Element elem) throws MalformedURLException {
            super(elem.getAttributeValue("name"), null, elem.getChildText("description"), new URL(elem.getChildText("url")), null);
            String webSiteName = elem.getAttributeValue("website");
            if (webSiteName != null) {
                this.webSite = new URL(webSiteName);
            }
        }

        @Override
        public Object getValueAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this;
                }
                case 1: {
                    return this.description;
                }
                case 2: {
                    return this.isLeaf ? this.webSite : null;
                }
            }
            return null;
        }
    }

    private static class FileRowCellRenderer
    extends DefaultTableCellRenderer {
        private FileRowCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component result;
            if (value instanceof TreeBrowserEntry) {
                TreeBrowserEntry fileRow = (TreeBrowserEntry)value;
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, fileRow.getName(), isSelected, hasFocus, row, column);
                label.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
                result = label;
            } else {
                result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return result;
        }
    }
}

